/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.Properties;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.util.CasVersion;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;

@Configuration(value="CasPropertiesConfiguration", proxyBeanMethods=false)
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasPropertiesConfiguration {
    @Bean
    public InitializingBean casPropertiesInitializingBean(ConfigurableEnvironment environment) {
        return () -> {
            Properties sysProps = System.getProperties();
            Properties properties = new Properties();
            if (CasVersion.getVersion() != null) {
                properties.put("info.cas.version", CasVersion.getVersion());
            }
            properties.put("info.cas.date", CasVersion.getDateTime());
            properties.put("info.cas.java.home", sysProps.get("java.home"));
            properties.put("info.cas.java.vendor", sysProps.get("java.vendor"));
            properties.put("info.cas.java.version", sysProps.get("java.version"));
            PropertiesPropertySource src = new PropertiesPropertySource(CasVersion.class.getName(), properties);
            environment.getPropertySources().addFirst((PropertySource)src);
        };
    }
}

