/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.List;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.web.ProtocolEndpointWebSecurityConfigurer;
import org.apereo.cas.web.security.CasWebSecurityConfigurerAdapter;
import org.apereo.cas.web.security.CasWebSecurityExpressionHandler;
import org.apereo.cas.web.security.CasWebSecurityJdbcConfigurerAdapter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.actuate.endpoint.web.PathMappedEndpoints;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.security.SecurityProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.access.expression.SecurityExpressionHandler;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.FilterInvocation;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration(value="CasWebAppSecurityConfiguration", proxyBeanMethods=false)
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@EnableGlobalMethodSecurity(prePostEnabled=true, securedEnabled=true, jsr250Enabled=true)
public class CasWebAppSecurityConfiguration {
    @Bean
    @ConditionalOnMissingBean(name={"casWebSecurityExpressionHandler"})
    public SecurityExpressionHandler<FilterInvocation> casWebSecurityExpressionHandler() {
        return new CasWebSecurityExpressionHandler();
    }

    @Bean
    public InitializingBean securityContextHolderInitialization() {
        return () -> SecurityContextHolder.setStrategyName((String)"MODE_THREADLOCAL");
    }

    @Configuration(value="CasWebappCoreSecurityConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasWebappCoreSecurityConfiguration {
        @Bean
        @ConditionalOnMissingBean(name={"casWebSecurityConfigurerAdapter"})
        public WebSecurityConfigurerAdapter casWebSecurityConfigurerAdapter(ObjectProvider<PathMappedEndpoints> pathMappedEndpoints, List<ProtocolEndpointWebSecurityConfigurer> configurersList, SecurityProperties securityProperties, CasConfigurationProperties casProperties, @Qualifier(value="casWebSecurityExpressionHandler") SecurityExpressionHandler<FilterInvocation> casWebSecurityExpressionHandler) {
            return new CasWebSecurityConfigurerAdapter(casProperties, securityProperties, casWebSecurityExpressionHandler, pathMappedEndpoints, configurersList);
        }

        @ConditionalOnProperty(name={"cas.monitor.endpoints.jdbc.query"})
        @Bean
        @ConditionalOnMissingBean(name={"casWebSecurityConfigurerJdbcAdapter"})
        public CasWebSecurityJdbcConfigurerAdapter casWebSecurityConfigurerJdbcAdapter(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext) {
            return new CasWebSecurityJdbcConfigurerAdapter(casProperties, (ApplicationContext)applicationContext);
        }

        @Bean
        @ConditionalOnMissingBean(name={"casWebAppSecurityWebMvcConfigurer"})
        public WebMvcConfigurer casWebAppSecurityWebMvcConfigurer() {
            return new WebMvcConfigurer(){

                public void addViewControllers(ViewControllerRegistry registry) {
                    registry.addViewController("/adminlogin").setViewName("admin/casAdminLoginView");
                    registry.setOrder(Integer.MIN_VALUE);
                }
            };
        }
    }
}

