/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import org.apache.catalina.startup.Tomcat;
import org.apache.coyote.http2.Http2Protocol;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.tomcat.CasTomcatServletWebServerFactory;
import org.apereo.cas.tomcat.CasTomcatServletWebServerFactoryCustomizer;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.autoconfigure.web.servlet.ServletWebServerFactoryAutoConfiguration;
import org.springframework.boot.autoconfigure.web.servlet.ServletWebServerFactoryCustomizer;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.server.ConfigurableServletWebServerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="CasEmbeddedContainerTomcatConfiguration", proxyBeanMethods=false)
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnClass(value={Tomcat.class, Http2Protocol.class})
@AutoConfigureBefore(value={ServletWebServerFactoryAutoConfiguration.class})
@AutoConfigureOrder(value=-2147483648)
public class CasEmbeddedContainerTomcatConfiguration {
    @ConditionalOnMissingBean(name={"casServletWebServerFactory"})
    @Bean
    public ConfigurableServletWebServerFactory casServletWebServerFactory(ServerProperties serverProperties, CasConfigurationProperties casProperties) {
        return new CasTomcatServletWebServerFactory(casProperties, serverProperties);
    }

    @ConditionalOnMissingBean(name={"casTomcatEmbeddedServletContainerCustomizer"})
    @Bean
    public ServletWebServerFactoryCustomizer casTomcatEmbeddedServletContainerCustomizer(ServerProperties serverProperties, CasConfigurationProperties casProperties) {
        return new CasTomcatServletWebServerFactoryCustomizer(serverProperties, casProperties);
    }
}

