/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.Collection;
import javax.servlet.Filter;
import org.apache.catalina.filters.CsrfPreventionFilter;
import org.apache.catalina.filters.RemoteAddrFilter;
import org.apereo.cas.config.CasEmbeddedContainerTomcatConfiguration;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.web.tomcat.CasEmbeddedApacheTomcatRemoteAddressProperties;
import org.apereo.cas.util.CollectionUtils;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.http.HttpStatus;

@Configuration(value="CasEmbeddedContainerTomcatFiltersConfiguration", proxyBeanMethods=false)
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ImportAutoConfiguration(value={CasEmbeddedContainerTomcatConfiguration.class})
public class CasEmbeddedContainerTomcatFiltersConfiguration {
    @ConditionalOnProperty(prefix="cas.server.tomcat.csrf", name={"enabled"}, havingValue="true")
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @Bean
    @ConditionalOnMissingBean(name={"tomcatCsrfPreventionFilter"})
    public FilterRegistrationBean<CsrfPreventionFilter> tomcatCsrfPreventionFilter() {
        FilterRegistrationBean bean = new FilterRegistrationBean();
        bean.setFilter((Filter)new CsrfPreventionFilter());
        bean.setUrlPatterns((Collection)CollectionUtils.wrap((Object)"/*"));
        bean.setName("tomcatCsrfPreventionFilter");
        return bean;
    }

    @ConditionalOnProperty(prefix="cas.server.tomcat.remote-addr", name={"enabled"}, havingValue="true")
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @Bean
    @ConditionalOnMissingBean(name={"tomcatRemoteAddressFilter"})
    public FilterRegistrationBean<RemoteAddrFilter> tomcatRemoteAddressFilter(CasConfigurationProperties casProperties) {
        FilterRegistrationBean bean = new FilterRegistrationBean();
        CasEmbeddedApacheTomcatRemoteAddressProperties addr = casProperties.getServer().getTomcat().getRemoteAddr();
        RemoteAddrFilter filter = new RemoteAddrFilter();
        filter.setAllow(addr.getAllowedClientIpAddressRegex());
        filter.setDeny(addr.getDeniedClientIpAddressRegex());
        filter.setDenyStatus(HttpStatus.UNAUTHORIZED.value());
        bean.setFilter((Filter)filter);
        bean.setUrlPatterns((Collection)CollectionUtils.wrap((Object)"/*"));
        bean.setName("tomcatRemoteAddressFilter");
        return bean;
    }
}

