/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.tomcat;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import lombok.Generated;
import org.apache.catalina.Context;
import org.apache.catalina.Valve;
import org.apache.catalina.authenticator.BasicAuthenticator;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.valves.ExtendedAccessLogValve;
import org.apache.catalina.valves.SSLValve;
import org.apache.catalina.valves.rewrite.RewriteValve;
import org.apache.commons.lang3.StringUtils;
import org.apache.coyote.AbstractProtocol;
import org.apache.coyote.UpgradeProtocol;
import org.apache.coyote.ajp.AbstractAjpProtocol;
import org.apache.coyote.ajp.AjpNio2Protocol;
import org.apache.coyote.ajp.AjpNioProtocol;
import org.apache.coyote.http11.Http11AprProtocol;
import org.apache.coyote.http11.Http11Nio2Protocol;
import org.apache.coyote.http11.Http11NioProtocol;
import org.apache.coyote.http2.Http2Protocol;
import org.apache.tomcat.util.descriptor.web.LoginConfig;
import org.apache.tomcat.util.descriptor.web.SecurityCollection;
import org.apache.tomcat.util.descriptor.web.SecurityConstraint;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.web.tomcat.CasEmbeddedApacheTomcatAjpProperties;
import org.apereo.cas.configuration.model.core.web.tomcat.CasEmbeddedApacheTomcatBasicAuthenticationProperties;
import org.apereo.cas.configuration.model.core.web.tomcat.CasEmbeddedApacheTomcatExtendedAccessLogProperties;
import org.apereo.cas.configuration.model.core.web.tomcat.CasEmbeddedApacheTomcatHttpProperties;
import org.apereo.cas.configuration.model.core.web.tomcat.CasEmbeddedApacheTomcatHttpProxyProperties;
import org.apereo.cas.configuration.model.core.web.tomcat.CasEmbeddedApacheTomcatProperties;
import org.apereo.cas.configuration.model.core.web.tomcat.CasEmbeddedApacheTomcatSocketProperties;
import org.apereo.cas.configuration.model.core.web.tomcat.CasEmbeddedApacheTomcatSslValveProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.util.ResourceUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.autoconfigure.web.servlet.ServletWebServerFactoryCustomizer;
import org.springframework.boot.web.embedded.tomcat.TomcatConnectorCustomizer;
import org.springframework.boot.web.embedded.tomcat.TomcatContextCustomizer;
import org.springframework.boot.web.embedded.tomcat.TomcatServletWebServerFactory;
import org.springframework.boot.web.servlet.server.ConfigurableServletWebServerFactory;
import org.springframework.core.io.Resource;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.SocketUtils;

public class CasTomcatServletWebServerFactoryCustomizer
extends ServletWebServerFactoryCustomizer {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasTomcatServletWebServerFactoryCustomizer.class);
    private final CasConfigurationProperties casProperties;
    private final ServerProperties serverProperties;

    public CasTomcatServletWebServerFactoryCustomizer(ServerProperties serverProperties, CasConfigurationProperties casProperties) {
        super(serverProperties);
        this.casProperties = casProperties;
        this.serverProperties = serverProperties;
    }

    private static void configureConnectorForProtocol(Connector connector, CasEmbeddedApacheTomcatHttpProxyProperties proxy) {
        Field handler = ReflectionUtils.findField(connector.getClass(), (String)"protocolHandler");
        if (handler != null) {
            ReflectionUtils.makeAccessible((Field)handler);
            if ("HTTP/2".equalsIgnoreCase(proxy.getProtocol())) {
                connector.addUpgradeProtocol((UpgradeProtocol)new Http2Protocol());
            } else {
                AbstractProtocol protocolHandlerInstance = null;
                switch (proxy.getProtocol()) {
                    case "AJP/2": {
                        protocolHandlerInstance = new AjpNio2Protocol();
                        AbstractAjpProtocol ajp1 = (AbstractAjpProtocol)AbstractAjpProtocol.class.cast(protocolHandlerInstance);
                        ajp1.setSecretRequired(proxy.isSecure());
                        ajp1.setSecret(proxy.getSecret());
                        break;
                    }
                    case "AJP/1.3": {
                        protocolHandlerInstance = new AjpNioProtocol();
                        AbstractAjpProtocol ajp2 = (AbstractAjpProtocol)AbstractAjpProtocol.class.cast(protocolHandlerInstance);
                        ajp2.setSecretRequired(proxy.isSecure());
                        ajp2.setSecret(proxy.getSecret());
                        break;
                    }
                    case "APR": {
                        protocolHandlerInstance = new Http11AprProtocol();
                        break;
                    }
                    case "HTTP/1.2": {
                        protocolHandlerInstance = new Http11Nio2Protocol();
                        break;
                    }
                    default: {
                        protocolHandlerInstance = new Http11NioProtocol();
                    }
                }
                protocolHandlerInstance.setPort(connector.getPort());
                ReflectionUtils.setField((Field)handler, (Object)connector, (Object)protocolHandlerInstance);
            }
            Field handlerClass = ReflectionUtils.findField(connector.getClass(), (String)"protocolHandlerClassName");
            if (handlerClass != null) {
                ReflectionUtils.makeAccessible((Field)handlerClass);
                ReflectionUtils.setField((Field)handlerClass, (Object)connector, (Object)connector.getProtocolHandler().getClass().getName());
            }
        }
    }

    public void customize(ConfigurableServletWebServerFactory factory) {
        if (factory instanceof TomcatServletWebServerFactory) {
            TomcatServletWebServerFactory tomcat = (TomcatServletWebServerFactory)factory;
            this.configureAjp(tomcat);
            this.configureHttp(tomcat);
            this.configureHttpProxy(tomcat);
            this.configureExtendedAccessLogValve(tomcat);
            this.configureRewriteValve(tomcat);
            this.configureSSLValve(tomcat);
            this.configureBasicAuthn(tomcat);
            this.finalizeConnectors(tomcat);
        }
    }

    private void finalizeConnectors(TomcatServletWebServerFactory tomcat) {
        tomcat.addConnectorCustomizers(new TomcatConnectorCustomizer[]{connector -> {
            CasEmbeddedApacheTomcatProperties tc = this.casProperties.getServer().getTomcat();
            connector.setProperty("Server", tc.getServerName());
            CasEmbeddedApacheTomcatSocketProperties socket = tc.getSocket();
            if (socket.getBufferPool() > 0) {
                connector.setProperty("socket.bufferPool", String.valueOf(socket.getBufferPool()));
            }
            if (socket.getAppReadBufSize() > 0) {
                connector.setProperty("socket.appReadBufSize", String.valueOf(socket.getAppReadBufSize()));
            }
            if (socket.getAppWriteBufSize() > 0) {
                connector.setProperty("socket.appWriteBufSize", String.valueOf(socket.getAppWriteBufSize()));
            }
            if (socket.getPerformanceBandwidth() >= 0) {
                connector.setProperty("socket.performanceBandwidth", String.valueOf(socket.getPerformanceBandwidth()));
            }
            if (socket.getPerformanceConnectionTime() >= 0) {
                connector.setProperty("socket.performanceConnectionTime", String.valueOf(socket.getPerformanceConnectionTime()));
            }
            if (socket.getPerformanceLatency() >= 0) {
                connector.setProperty("socket.performanceLatency", String.valueOf(socket.getPerformanceLatency()));
            }
        }});
    }

    private void configureBasicAuthn(TomcatServletWebServerFactory tomcat) {
        CasEmbeddedApacheTomcatBasicAuthenticationProperties basic = this.casProperties.getServer().getTomcat().getBasicAuthn();
        if (basic.isEnabled()) {
            tomcat.addContextCustomizers(new TomcatContextCustomizer[]{ctx -> {
                LoginConfig config = new LoginConfig();
                config.setAuthMethod("BASIC");
                ctx.setLoginConfig(config);
                basic.getSecurityRoles().forEach(arg_0 -> ((Context)ctx).addSecurityRole(arg_0));
                basic.getAuthRoles().forEach(r -> {
                    SecurityConstraint constraint = new SecurityConstraint();
                    constraint.addAuthRole(r);
                    SecurityCollection collection = new SecurityCollection();
                    basic.getPatterns().forEach(arg_0 -> ((SecurityCollection)collection).addPattern(arg_0));
                    constraint.addCollection(collection);
                    ctx.addConstraint(constraint);
                });
            }});
            tomcat.addContextValves(new Valve[]{new BasicAuthenticator()});
        }
    }

    private void configureExtendedAccessLogValve(TomcatServletWebServerFactory tomcat) {
        CasEmbeddedApacheTomcatExtendedAccessLogProperties ext = this.casProperties.getServer().getTomcat().getExtAccessLog();
        if (ext.isEnabled() && StringUtils.isNotBlank((CharSequence)ext.getPattern())) {
            LOGGER.debug("Creating extended access log valve configuration for the embedded tomcat container...");
            ExtendedAccessLogValve valve = new ExtendedAccessLogValve();
            valve.setPattern(ext.getPattern());
            if (StringUtils.isBlank((CharSequence)ext.getDirectory())) {
                valve.setDirectory(this.serverProperties.getTomcat().getAccesslog().getDirectory());
            } else {
                valve.setDirectory(ext.getDirectory());
            }
            valve.setPrefix(ext.getPrefix());
            valve.setSuffix(ext.getSuffix());
            valve.setAsyncSupported(true);
            valve.setEnabled(true);
            valve.setRotatable(true);
            valve.setBuffered(true);
            tomcat.addEngineValves(new Valve[]{valve});
        }
    }

    private void configureHttp(TomcatServletWebServerFactory tomcat) {
        this.casProperties.getServer().getTomcat().getHttp().stream().filter(CasEmbeddedApacheTomcatHttpProperties::isEnabled).forEach(http -> {
            LOGGER.debug("Creating HTTP configuration for the embedded tomcat container...");
            Connector connector = new Connector(http.getProtocol());
            int port = http.getPort();
            if (port <= 0) {
                LOGGER.warn("No explicit port configuration is provided to CAS. Scanning for available ports...");
                port = SocketUtils.findAvailableTcpPort();
            }
            LOGGER.info("Activated embedded tomcat container HTTP port on [{}]", (Object)port);
            connector.setPort(port);
            if (http.getRedirectPort() > 0) {
                connector.setRedirectPort(http.getRedirectPort());
            }
            connector.setScheme(http.getScheme());
            connector.setSecure(http.isSecure());
            LOGGER.debug("Configuring embedded tomcat container for HTTP2 protocol support");
            connector.addUpgradeProtocol((UpgradeProtocol)new Http2Protocol());
            http.getAttributes().forEach((arg_0, arg_1) -> ((Connector)connector).setProperty(arg_0, arg_1));
            tomcat.addAdditionalTomcatConnectors(new Connector[]{connector});
        });
    }

    private void configureHttpProxy(TomcatServletWebServerFactory tomcat) {
        CasEmbeddedApacheTomcatHttpProxyProperties proxy = this.casProperties.getServer().getTomcat().getHttpProxy();
        if (proxy.isEnabled()) {
            LOGGER.debug("Customizing HTTP proxying for connector listening on port [{}]", (Object)tomcat.getPort());
            tomcat.getTomcatConnectorCustomizers().add(connector -> {
                connector.setSecure(proxy.isSecure());
                connector.setScheme(proxy.getScheme());
                if (StringUtils.isNotBlank((CharSequence)proxy.getProtocol())) {
                    LOGGER.debug("Setting HTTP proxying protocol to [{}]", (Object)proxy.getProtocol());
                    CasTomcatServletWebServerFactoryCustomizer.configureConnectorForProtocol(connector, proxy);
                }
                if (proxy.getRedirectPort() > 0) {
                    LOGGER.debug("Setting HTTP proxying redirect port to [{}]", (Object)proxy.getRedirectPort());
                    connector.setRedirectPort(proxy.getRedirectPort());
                }
                if (proxy.getProxyPort() > 0) {
                    LOGGER.debug("Setting HTTP proxying proxy port to [{}]", (Object)proxy.getProxyPort());
                    connector.setProxyPort(proxy.getProxyPort());
                }
                connector.addUpgradeProtocol((UpgradeProtocol)new Http2Protocol());
                proxy.getAttributes().forEach((arg_0, arg_1) -> ((Connector)connector).setProperty(arg_0, arg_1));
                LOGGER.info("Configured connector listening on port [{}]", (Object)tomcat.getPort());
            });
        } else {
            LOGGER.trace("HTTP proxying is not enabled for CAS; Connector configuration for port [{}] is not modified.", (Object)tomcat.getPort());
        }
    }

    private void configureAjp(TomcatServletWebServerFactory tomcat) {
        CasEmbeddedApacheTomcatAjpProperties ajp = this.casProperties.getServer().getTomcat().getAjp();
        if (ajp.isEnabled() && ajp.getPort() > 0) {
            LOGGER.debug("Creating AJP configuration for the embedded tomcat container...");
            Connector ajpConnector = new Connector(ajp.getProtocol());
            ajpConnector.setPort(ajp.getPort());
            ajpConnector.setSecure(ajp.isSecure());
            ajpConnector.setAllowTrace(ajp.isAllowTrace());
            ajpConnector.setScheme(ajp.getScheme());
            ajpConnector.setAsyncTimeout(Beans.newDuration((String)ajp.getAsyncTimeout()).toMillis());
            ajpConnector.setEnableLookups(ajp.isEnableLookups());
            ajpConnector.setMaxPostSize(ajp.getMaxPostSize());
            ajpConnector.addUpgradeProtocol((UpgradeProtocol)new Http2Protocol());
            AbstractAjpProtocol handler = (AbstractAjpProtocol)ajpConnector.getProtocolHandler();
            if (handler != null) {
                handler.setSecretRequired(ajp.isSecure());
                handler.setSecret(ajp.getSecret());
            }
            if (ajp.getProxyPort() > 0) {
                LOGGER.debug("Set AJP proxy port to [{}]", (Object)ajp.getProxyPort());
                ajpConnector.setProxyPort(ajp.getProxyPort());
            }
            if (ajp.getRedirectPort() > 0) {
                LOGGER.debug("Set AJP redirect port to [{}]", (Object)ajp.getRedirectPort());
                ajpConnector.setRedirectPort(ajp.getRedirectPort());
            }
            ajp.getAttributes().forEach((arg_0, arg_1) -> ((Connector)ajpConnector).setProperty(arg_0, arg_1));
            tomcat.addAdditionalTomcatConnectors(new Connector[]{ajpConnector});
        }
    }

    private void configureSSLValve(TomcatServletWebServerFactory tomcat) {
        CasEmbeddedApacheTomcatSslValveProperties valveConfig = this.casProperties.getServer().getTomcat().getSslValve();
        if (valveConfig.isEnabled()) {
            LOGGER.debug("Adding SSLValve to context of the embedded tomcat container...");
            SSLValve valve = new SSLValve();
            valve.setSslCipherHeader(valveConfig.getSslCipherHeader());
            valve.setSslCipherUserKeySizeHeader(valveConfig.getSslCipherUserKeySizeHeader());
            valve.setSslClientCertHeader(valveConfig.getSslClientCertHeader());
            valve.setSslSessionIdHeader(valveConfig.getSslSessionIdHeader());
            tomcat.addContextValves(new Valve[]{valve});
        }
    }

    private void configureRewriteValve(TomcatServletWebServerFactory tomcat) {
        final Resource res = this.casProperties.getServer().getTomcat().getRewriteValve().getLocation();
        if (ResourceUtils.doesResourceExist((Resource)res)) {
            LOGGER.debug("Configuring rewrite valve at [{}]", (Object)res);
            RewriteValve valve = new RewriteValve(){

                public synchronized void startInternal() {
                    FunctionUtils.doUnchecked(u -> {
                        super.startInternal();
                        try (InputStream is = res.getInputStream();
                             InputStreamReader isr = new InputStreamReader(is, StandardCharsets.UTF_8);
                             BufferedReader buffer = new BufferedReader(isr);){
                            this.parse(buffer);
                        }
                    }, (Object[])new Object[0]);
                }
            };
            valve.setAsyncSupported(true);
            valve.setEnabled(true);
            LOGGER.debug("Creating rewrite valve configuration for the embedded tomcat container...");
            tomcat.addContextValves(new Valve[]{valve});
        }
    }
}

