/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web;

import java.time.Instant;
import lombok.Generated;
import org.apereo.cas.CasEmbeddedContainerUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.util.AsciiArtUtils;
import org.apereo.cas.util.DateTimeUtils;
import org.apereo.cas.web.CasWebApplicationReadyListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.Banner;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.data.mongo.MongoDataAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.mongo.MongoAutoConfiguration;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@EnableDiscoveryClient
@SpringBootApplication(proxyBeanMethods=false, exclude={DataSourceAutoConfiguration.class, MongoAutoConfiguration.class, MongoDataAutoConfiguration.class})
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@EnableAsync
@EnableAspectJAutoProxy
@EnableTransactionManagement
@EnableScheduling
public class CasWebApplication
implements CasWebApplicationReadyListener {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasWebApplication.class);

    public static void main(String[] args) {
        CasEmbeddedContainerUtils.getLoggingInitialization().ifPresent(init -> init.setMainArguments(args));
        Banner banner = CasEmbeddedContainerUtils.getCasBannerInstance();
        new SpringApplicationBuilder(new Class[]{CasWebApplication.class}).banner(banner).web(WebApplicationType.SERVLET).logStartupInfo(true).applicationStartup(CasEmbeddedContainerUtils.getApplicationStartup()).run(args);
    }

    @Override
    public void handleApplicationReadyEvent(ApplicationReadyEvent event) {
        AsciiArtUtils.printAsciiArtReady((Logger)LOGGER, (String)"");
        LOGGER.info("Ready to process requests @ [{}]", (Object)DateTimeUtils.zonedDateTimeOf((Instant)Instant.ofEpochMilli(event.getTimestamp())));
    }

    @Generated
    public CasWebApplication() {
    }
}

