/*
 * Decompiled with CFR 0.152.
 */
package org.apidesign.bck2brwsr.aot;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.orfjackal.retrolambda.Transformers;
import net.orfjackal.retrolambda.asm.ClassReader;
import net.orfjackal.retrolambda.files.OutputDirectory;
import net.orfjackal.retrolambda.interfaces.ClassHierarchyAnalyzer;
import net.orfjackal.retrolambda.lambdas.LambdaClassDumper;
import net.orfjackal.retrolambda.lambdas.LambdaClassSaver;
import org.apidesign.bck2brwsr.aot.Bck2BrwsrJars;
import org.apidesign.bck2brwsr.aot.BytecodeProcessor;
import org.apidesign.bck2brwsr.core.ExtraJavaScript;
import org.apidesign.vm4brwsr.Bck2Brwsr;

@ExtraJavaScript(processByteCode=false, resource="")
final class RetroLambda
extends OutputDirectory
implements BytecodeProcessor {
    private Map<String, byte[]> converted;
    private final Transformers transformers = new Transformers(51, false, new ClassHierarchyAnalyzer());
    private final LambdaClassSaver saver = new LambdaClassSaver((OutputDirectory)this, this.transformers);

    public RetroLambda() {
        super(null);
    }

    public void writeFile(Path relativePath, byte[] content) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void writeClass(byte[] bytecode) throws IOException {
        if (bytecode == null) {
            return;
        }
        ClassReader cr = new ClassReader(bytecode);
        String className = cr.getClassName();
        this.putBytecode(className + ".class", bytecode);
    }

    private void putBytecode(String className, byte[] backportedBytecode) {
        assert (className.endsWith(".class")) : "Full resource: " + className;
        if (this.converted == null) {
            this.converted = new HashMap<String, byte[]>();
        }
        this.converted.put(className, backportedBytecode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, byte[]> process(String className, byte[] byteCode, Bck2Brwsr.Resources resources) throws IOException {
        int minor = byteCode[4] << 8 | byteCode[5];
        int major = byteCode[6] << 8 | byteCode[7];
        if (major <= 51) {
            return null;
        }
        ClassLoader prev = Thread.currentThread().getContextClassLoader();
        try (LambdaClassDumper dumper = new LambdaClassDumper(this.saver);){
            Thread.currentThread().setContextClassLoader(new ResLdr(resources));
            dumper.install();
            byte[] newB = this.transformers.backportClass(new ClassReader(byteCode));
            if (!Arrays.equals(newB, byteCode)) {
                this.putBytecode(className, newB);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            Thread.currentThread().setContextClassLoader(prev);
        }
        Map<String, byte[]> ret = this.converted;
        this.converted = null;
        return ret;
    }

    private static final class ResLdr
    extends ClassLoader {
        private final Bck2Brwsr.Resources res;

        public ResLdr(Bck2Brwsr.Resources res) {
            this.res = res;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            Class<?> c = this.findLoadedClass(name);
            if (c != null) {
                return c;
            }
            if (name.startsWith("java.")) {
                return super.loadClass(name);
            }
            String r = name.replace('.', '/') + ".class";
            try (InputStream is = this.res.get(r);){
                if (is == null) {
                    throw new ClassNotFoundException(name);
                }
                byte[] arr = Bck2BrwsrJars.readFrom(is);
                Class<?> clazz = this.defineClass(name, arr, 0, arr.length);
                return clazz;
            }
            catch (IOException e) {
                return super.loadClass(name);
            }
        }
    }
}

