/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.kubernetes.impl;

import io.fabric8.kubernetes.api.builder.v3_1.TypedVisitor;
import io.fabric8.kubernetes.api.builder.v3_1.Visitor;
import io.fabric8.kubernetes.clnt.v3_1.ConfigBuilder;
import io.fabric8.kubernetes.clnt.v3_1.DefaultKubernetesClient;
import io.fabric8.kubernetes.clnt.v3_1.KubernetesClient;
import org.arquillian.cube.impl.util.Strings;
import org.arquillian.cube.kubernetes.api.Configuration;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.ApplicationScoped;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;

public class ClientCreator {
    @Inject
    @ApplicationScoped
    private InstanceProducer<KubernetesClient> producer;

    public void createClient(@Observes Configuration config) {
        ConfigBuilder configBuilder = (ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)new ConfigBuilder().withNamespace(config.getNamespace())).withApiVersion(config.getApiVersion())).withTrustCerts(config.isTrustCerts())).accept((Visitor)new TypedVisitor<ConfigBuilder>(){

            public void visit(ConfigBuilder b) {
                b.withNoProxy(b.getNoProxy() == null ? new String[]{} : b.getNoProxy());
            }
        });
        if (Strings.isNotNullOrEmpty((String)config.getMasterUrl().toString())) {
            configBuilder.withMasterUrl(config.getMasterUrl().toString());
        }
        if (Strings.isNotNullOrEmpty((String)config.getToken())) {
            configBuilder.withOauthToken(config.getToken());
        }
        if (Strings.isNotNullOrEmpty((String)config.getUsername()) && Strings.isNotNullOrEmpty((String)config.getPassword())) {
            ((ConfigBuilder)configBuilder.withUsername(config.getUsername())).withPassword(config.getPassword());
        }
        this.producer.set((Object)new DefaultKubernetesClient(configBuilder.build()));
    }
}

