/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.kubernetes.impl;

import io.fabric8.kubernetes.clnt.v3_1.ConfigBuilder;
import io.fabric8.kubernetes.clnt.v3_1.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.regex.Pattern;
import org.arquillian.cube.impl.util.ConfigUtil;
import org.arquillian.cube.impl.util.Strings;
import org.arquillian.cube.impl.util.SystemEnvironmentVariables;
import org.arquillian.cube.kubernetes.api.Configuration;
import org.arquillian.cube.kubernetes.api.KubernetesResourceLocator;
import org.arquillian.cube.kubernetes.impl.DefaultConfigurationBuilder;

public class DefaultConfiguration
implements Configuration {
    private static final String ENV_VAR_REGEX = "env.([a-zA-Z0-9_]+)";
    private static final Pattern ENV_VAR_PATTERN = Pattern.compile("env.([a-zA-Z0-9_]+)");
    private static final String ROOT = "/";
    private final String sessionId;
    private final String namespace;
    private final URL masterUrl;
    private final Map<String, String> scriptEnvironmentVariables;
    private final URL environmentSetupScriptUrl;
    private final URL environmentTeardownScriptUrl;
    private final URL environmentConfigUrl;
    private final List<URL> environmentDependencies;
    private final boolean namespaceLazyCreateEnabled;
    private final boolean namespaceCleanupEnabled;
    private final long namespaceCleanupTimeout;
    private final boolean namespaceCleanupConfirmationEnabled;
    private final boolean namespaceUseCurrentEnabled;
    private final boolean namespaceDestroyEnabled;
    private final boolean namespaceDestroyConfirmationEnabled;
    private final long namespaceDestroyTimeout;
    private final boolean waitEnabled;
    private final long waitTimeout;
    private final long waitPollInterval;
    private final List<String> waitForServiceList;
    private final boolean ansiLoggerEnabled;
    private final boolean environmentInitEnabled;
    private final boolean logCopyEnabled;
    private final String logPath;
    private final String kubernetesDomain;
    private final String dockerRegistry;
    private final String username;
    private final String password;
    private final String apiVersion;
    private final boolean trustCerts;
    private String token;

    public DefaultConfiguration(String sessionId, URL masterUrl, String namespace, Map<String, String> scriptEnvironmentVariables, URL environmentSetupScriptUrl, URL environmentTeardownScriptUrl, URL environmentConfigUrl, List<URL> environmentDependencies, boolean namespaceUseCurrentEnabled, boolean namespaceLazyCreateEnabled, boolean namespaceCleanupEnabled, long namespaceCleanupTimeout, boolean namespaceCleanupConfirmationEnabled, boolean namespaceDestroyEnabled, boolean namespaceDestroyConfirmationEnabled, long namespaceDestroyTimeout, boolean waitEnabled, long waitTimeout, long waitPollInterval, List<String> waitForServiceList, boolean ansiLoggerEnabled, boolean environmentInitEnabled, boolean logCopyEnabled, String logPath, String kubernetesDomain, String dockerRegistry, String token, String username, String password, String apiVersion, boolean trustCerts) {
        this.masterUrl = masterUrl;
        this.scriptEnvironmentVariables = scriptEnvironmentVariables;
        this.environmentSetupScriptUrl = environmentSetupScriptUrl;
        this.environmentTeardownScriptUrl = environmentTeardownScriptUrl;
        this.environmentDependencies = environmentDependencies;
        this.environmentConfigUrl = environmentConfigUrl;
        this.sessionId = sessionId;
        this.namespace = namespace;
        this.namespaceLazyCreateEnabled = namespaceLazyCreateEnabled;
        this.namespaceCleanupEnabled = namespaceCleanupEnabled;
        this.namespaceCleanupTimeout = namespaceCleanupTimeout;
        this.namespaceCleanupConfirmationEnabled = namespaceCleanupConfirmationEnabled;
        this.namespaceDestroyEnabled = namespaceDestroyEnabled;
        this.namespaceDestroyConfirmationEnabled = namespaceDestroyConfirmationEnabled;
        this.namespaceDestroyTimeout = namespaceDestroyTimeout;
        this.namespaceUseCurrentEnabled = namespaceUseCurrentEnabled;
        this.waitEnabled = waitEnabled;
        this.waitTimeout = waitTimeout;
        this.waitPollInterval = waitPollInterval;
        this.waitForServiceList = waitForServiceList;
        this.ansiLoggerEnabled = ansiLoggerEnabled;
        this.environmentInitEnabled = environmentInitEnabled;
        this.logCopyEnabled = logCopyEnabled;
        this.logPath = logPath;
        this.kubernetesDomain = kubernetesDomain;
        this.dockerRegistry = dockerRegistry;
        this.token = token;
        this.username = username;
        this.password = password;
        this.apiVersion = apiVersion;
        this.trustCerts = trustCerts;
    }

    public static DefaultConfiguration fromMap(Map<String, String> map) {
        try {
            String sessionId = UUID.randomUUID().toString().split("-")[0];
            String namespace = ConfigUtil.getBooleanProperty((String)"namespace.use.current", map, (Boolean)false) != false ? new ConfigBuilder().build().getNamespace() : ConfigUtil.getStringProperty((String)"namespace.use.existing", map, null);
            Boolean shouldDestroyNamespace = false;
            if (Strings.isNullOrEmpty((String)namespace)) {
                namespace = ConfigUtil.getStringProperty((String)"namespace.prefix", map, (String)"itest") + "-" + sessionId;
                shouldDestroyNamespace = true;
            }
            return ((DefaultConfigurationBuilder)((DefaultConfigurationBuilder)((DefaultConfigurationBuilder)((DefaultConfigurationBuilder)((DefaultConfigurationBuilder)((DefaultConfigurationBuilder)((DefaultConfigurationBuilder)((DefaultConfigurationBuilder)((DefaultConfigurationBuilder)((DefaultConfigurationBuilder)((DefaultConfigurationBuilder)((DefaultConfigurationBuilder)((DefaultConfigurationBuilder)((DefaultConfigurationBuilder)((DefaultConfigurationBuilder)((DefaultConfigurationBuilder)((DefaultConfigurationBuilder)((DefaultConfigurationBuilder)((DefaultConfigurationBuilder)((DefaultConfigurationBuilder)((DefaultConfigurationBuilder)((DefaultConfigurationBuilder)((DefaultConfigurationBuilder)((DefaultConfigurationBuilder)((DefaultConfigurationBuilder)((DefaultConfigurationBuilder)((DefaultConfigurationBuilder)((DefaultConfigurationBuilder)((DefaultConfigurationBuilder)((DefaultConfigurationBuilder)((DefaultConfigurationBuilder)new DefaultConfigurationBuilder().withSessionId(sessionId)).withNamespace(namespace)).withMasterUrl(new URL(ConfigUtil.getStringProperty((String)"master.url", (String)"kubernetes.master", map, (String)FALLBACK_CLIENT_CONFIG.getMasterUrl())))).withEnvironmentInitEnabled(ConfigUtil.getBooleanProperty((String)"env.init.enabled", map, (Boolean)true))).withLogCopyEnabled(ConfigUtil.getBooleanProperty((String)"logs.copy", map, (Boolean)false))).withLogPath(ConfigUtil.getStringProperty((String)"logs.path", map, null))).withScriptEnvironmentVariables(DefaultConfiguration.parseMap(map.get("env.script.env")))).withEnvironmentSetupScriptUrl(DefaultConfiguration.asUrlOrResource(ConfigUtil.getStringProperty((String)"env.setup.script.url", map, null)))).withEnvironmentTeardownScriptUrl(DefaultConfiguration.asUrlOrResource(ConfigUtil.getStringProperty((String)"env.teardown.script.url", map, null)))).withEnvironmentConfigUrl(DefaultConfiguration.getKubernetesConfigurationUrl(map))).withEnvironmentDependencies(ConfigUtil.asURL((List)Strings.splitAndTrimAsList((String)ConfigUtil.getStringProperty((String)"env.dependencies", map, (String)""), (String)"\\s*,\\s*")))).withNamespaceLazyCreateEnabled(ConfigUtil.getBooleanProperty((String)"namespace.lazy.enabled", map, (Boolean)DEFAULT_NAMESPACE_LAZY_CREATE_ENABLED))).withNamespaceCleanupEnabled(ConfigUtil.getBooleanProperty((String)"namespace.cleanup.enabled", map, (Boolean)true))).withNamespaceCleanupConfirmationEnabled(ConfigUtil.getBooleanProperty((String)"namespace.cleanup.confirm.enabled", map, (Boolean)false))).withNamespaceCleanupTimeout(ConfigUtil.getLongProperty((String)"namespace.cleanup.timeout", map, (Long)DEFAULT_NAMESPACE_CLEANUP_TIMEOUT))).withNamespaceUseCurrentEnabled(ConfigUtil.getBooleanProperty((String)"namespace.use.current", map, (Boolean)false))).withNamespaceDestroyEnabled(ConfigUtil.getBooleanProperty((String)"namespace.destroy.enabled", map, (Boolean)shouldDestroyNamespace))).withNamespaceDestroyConfirmationEnabled(ConfigUtil.getBooleanProperty((String)"namespace.destroy.confirm.enabled", map, (Boolean)false))).withNamespaceDestroyTimeout(ConfigUtil.getLongProperty((String)"namespace.destroy.timeout", map, (Long)DEFAULT_NAMESPACE_DESTROY_TIMEOUT))).withWaitEnabled(ConfigUtil.getBooleanProperty((String)"wait.enabled", map, (Boolean)true))).withWaitTimeout(ConfigUtil.getLongProperty((String)"wait.timeout", map, (Long)DEFAULT_WAIT_TIMEOUT))).withWaitPollInterval(ConfigUtil.getLongProperty((String)"wait.poll.interval", map, (Long)DEFAULT_WAIT_POLL_INTERVAL))).withWaitForServiceList(Strings.splitAndTrimAsList((String)ConfigUtil.getStringProperty((String)"wait.for.service.list", map, (String)""), (String)"\\s*,\\s*"))).withAnsiLoggerEnabled(ConfigUtil.getBooleanProperty((String)"ansi.logger.enabled", map, (Boolean)true))).withKubernetesDomain(ConfigUtil.getStringProperty((String)"domain", (String)"kubernetes.domain", map, null))).withDockerRegistry(DefaultConfiguration.getDockerRegistry(map))).withToken(ConfigUtil.getStringProperty((String)"cube.auth.token", map, null))).withUsername(ConfigUtil.getStringProperty((String)"cube.username", map, null))).withPassword(ConfigUtil.getStringProperty((String)"cube.password", map, null))).withApiVersion(ConfigUtil.getStringProperty((String)"cube.api.version", map, (String)"v1"))).withTrustCerts(ConfigUtil.getBooleanProperty((String)"cube.trust.certs", map, (Boolean)true))).build();
        }
        catch (Throwable t) {
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
    }

    public static String getDockerRegistry(Map<String, String> map) throws MalformedURLException {
        String registry = SystemEnvironmentVariables.getEnvironmentOrPropertyVariable((String)"docker.registry");
        if (Strings.isNotNullOrEmpty((String)registry)) {
            return registry;
        }
        String registryHost = SystemEnvironmentVariables.getEnvironmentVariable((String)"DOCKER_REGISTRY_HOST");
        String registryPort = SystemEnvironmentVariables.getEnvironmentVariable((String)"DOCKER_REGISTRY_PORT");
        if (Strings.isNotNullOrEmpty((String)registry) && Strings.isNotNullOrEmpty((String)registryPort)) {
            return String.format("%s:%s", registryHost, registryPort);
        }
        if (map.containsKey("docker.registry")) {
            return map.get("docker.registry");
        }
        return null;
    }

    public static URL getKubernetesConfigurationUrl(Map<String, String> map) throws MalformedURLException {
        if (Strings.isNotNullOrEmpty((String)Utils.getSystemPropertyOrEnvVar((String)"env.config.url", (String)""))) {
            return new URL(Utils.getSystemPropertyOrEnvVar((String)"env.config.url", (String)""));
        }
        if (Strings.isNotNullOrEmpty((String)Utils.getSystemPropertyOrEnvVar((String)"env.config.resource.name", (String)""))) {
            String resourceName = Utils.getSystemPropertyOrEnvVar((String)"env.config.resource.name", (String)"");
            return DefaultConfiguration.findConfigResource(resourceName);
        }
        if (map.containsKey("env.config.url")) {
            return new URL(map.get("env.config.url"));
        }
        if (map.containsKey("env.config.resource.name")) {
            String resourceName = map.get("env.config.resource.name");
            return DefaultConfiguration.findConfigResource(resourceName);
        }
        return null;
    }

    public static URL findConfigResource(String resourceName) {
        String[] resourceNamePrefix;
        URL url;
        if (Strings.isNullOrEmpty((String)resourceName)) {
            return null;
        }
        URL uRL = url = resourceName.startsWith(ROOT) ? DefaultConfiguration.class.getResource(resourceName) : DefaultConfiguration.class.getResource(ROOT + resourceName);
        if (url != null) {
            return url;
        }
        for (String resource : resourceNamePrefix = new String[]{"META-INF/fabric8/", "META-INF/fabric8/"}) {
            String fullResourceName = resource + resourceName;
            URL candidate = KubernetesResourceLocator.class.getResource(fullResourceName.startsWith(ROOT) ? fullResourceName : ROOT + fullResourceName);
            if (candidate == null) continue;
            return candidate;
        }
        return null;
    }

    public static URL asUrlOrResource(String s) {
        if (Strings.isNullOrEmpty((String)s)) {
            return null;
        }
        try {
            return new URL(s);
        }
        catch (MalformedURLException e) {
            return DefaultConfiguration.findConfigResource(s);
        }
    }

    public static Map<String, String> parseMap(String s) throws IOException {
        if (Strings.isNullOrEmpty((String)s)) {
            return Collections.EMPTY_MAP;
        }
        Properties properties = new Properties();
        ByteArrayInputStream is = new ByteArrayInputStream(s.getBytes(Charset.defaultCharset()));
        Object object = null;
        try {
            properties.load(is);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (is != null) {
                if (object != null) {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ((InputStream)is).close();
                }
            }
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (String key : properties.stringPropertyNames()) {
            map.put(key, properties.getProperty(key));
        }
        return map;
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public URL getMasterUrl() {
        return this.masterUrl;
    }

    @Override
    public Map<String, String> getScriptEnvironmentVariables() {
        return this.scriptEnvironmentVariables;
    }

    @Override
    public URL getEnvironmentSetupScriptUrl() {
        return this.environmentSetupScriptUrl;
    }

    @Override
    public URL getEnvironmentTeardownScriptUrl() {
        return this.environmentTeardownScriptUrl;
    }

    @Override
    public URL getEnvironmentConfigUrl() {
        return this.environmentConfigUrl;
    }

    @Override
    public List<URL> getEnvironmentDependencies() {
        return this.environmentDependencies;
    }

    @Override
    public boolean isNamespaceLazyCreateEnabled() {
        return this.namespaceLazyCreateEnabled;
    }

    @Override
    public boolean isNamespaceCleanupEnabled() {
        return this.namespaceCleanupEnabled;
    }

    @Override
    public long getNamespaceCleanupTimeout() {
        return this.namespaceCleanupTimeout;
    }

    @Override
    public boolean isNamespaceCleanupConfirmationEnabled() {
        return this.namespaceCleanupConfirmationEnabled;
    }

    @Override
    public boolean isNamespaceDestroyEnabled() {
        return this.namespaceDestroyEnabled;
    }

    @Override
    public boolean isNamespaceDestroyConfirmationEnabled() {
        return this.namespaceDestroyConfirmationEnabled;
    }

    @Override
    public boolean isNamespaceUseCurrentEnabled() {
        return this.namespaceUseCurrentEnabled;
    }

    @Override
    public long getNamespaceDestroyTimeout() {
        return this.namespaceDestroyTimeout;
    }

    @Override
    public boolean isWaitEnabled() {
        return this.waitEnabled;
    }

    @Override
    public long getWaitTimeout() {
        return this.waitTimeout;
    }

    @Override
    public long getWaitPollInterval() {
        return this.waitPollInterval;
    }

    @Override
    public List<String> getWaitForServiceList() {
        return this.waitForServiceList;
    }

    @Override
    public boolean isAnsiLoggerEnabled() {
        return this.ansiLoggerEnabled;
    }

    @Override
    public boolean isEnvironmentInitEnabled() {
        return this.environmentInitEnabled;
    }

    @Override
    public boolean isLogCopyEnabled() {
        return this.logCopyEnabled;
    }

    @Override
    public String getLogPath() {
        return this.logPath;
    }

    @Override
    public String getKubernetesDomain() {
        return this.kubernetesDomain;
    }

    @Override
    public String getDockerRegistry() {
        return this.dockerRegistry;
    }

    public boolean hasBasicAuth() {
        return Strings.isNotNullOrEmpty((String)this.username) && Strings.isNotNullOrEmpty((String)this.password);
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public String getToken() {
        return this.token;
    }

    @Override
    public boolean isTrustCerts() {
        return this.trustCerts;
    }

    protected void setToken(String token) {
        this.token = token;
    }

    public String toString() {
        String lineSeparator = System.lineSeparator();
        StringBuilder content = new StringBuilder();
        content.append("CubeKubernetesConfiguration: ").append(lineSeparator);
        if (this.namespace != null) {
            content.append("  ").append("namespace").append(" = ").append(this.namespace).append(lineSeparator);
        }
        if (this.masterUrl != null) {
            content.append("  ").append("master.url").append(" = ").append(this.masterUrl).append(lineSeparator);
        }
        if (this.scriptEnvironmentVariables != null) {
            content.append("  ").append("env.script.env").append(" = ").append(this.scriptEnvironmentVariables).append(lineSeparator);
        }
        if (this.environmentSetupScriptUrl != null) {
            content.append("  ").append("env.setup.script.url").append(" = ").append(this.environmentSetupScriptUrl).append(lineSeparator);
        }
        if (this.environmentTeardownScriptUrl != null) {
            content.append("  ").append("env.teardown.script.url").append(" = ").append(this.environmentTeardownScriptUrl).append(lineSeparator);
        }
        if (this.environmentConfigUrl != null) {
            content.append("  ").append("env.config.url").append(" = ").append(this.environmentConfigUrl).append(lineSeparator);
        }
        if (this.environmentDependencies != null) {
            content.append("  ").append("env.dependencies").append(" = ").append(this.environmentDependencies).append(lineSeparator);
        }
        content.append("  ").append("namespace.lazy.enabled").append(" = ").append(this.namespaceLazyCreateEnabled).append(lineSeparator);
        content.append("  ").append("namespace.cleanup.enabled").append(" = ").append(this.namespaceCleanupEnabled).append(lineSeparator);
        content.append("  ").append("namespace.cleanup.timeout").append(" = ").append(this.namespaceCleanupTimeout).append(lineSeparator);
        content.append("  ").append("namespace.cleanup.confirm.enabled").append(" = ").append(this.namespaceCleanupConfirmationEnabled).append(lineSeparator);
        content.append("  ").append("namespace.destroy.enabled").append(" = ").append(this.namespaceDestroyEnabled).append(lineSeparator);
        content.append("  ").append("namespace.destroy.confirm.enabled").append(" = ").append(this.namespaceDestroyConfirmationEnabled).append(lineSeparator);
        content.append("  ").append("namespace.destroy.timeout").append(" = ").append(this.namespaceDestroyTimeout).append(lineSeparator);
        content.append("  ").append("wait.enabled").append(" = ").append(this.waitEnabled).append(lineSeparator);
        content.append("  ").append("wait.timeout").append(" = ").append(this.waitTimeout).append(lineSeparator);
        content.append("  ").append("wait.poll.interval").append(" = ").append(this.waitPollInterval).append(lineSeparator);
        content.append("  ").append("ansi.logger.enabled").append(" = ").append(this.ansiLoggerEnabled).append(lineSeparator);
        content.append("  ").append("env.init.enabled").append(" = ").append(this.environmentInitEnabled).append(lineSeparator);
        content.append("  ").append("logs.copy").append(" = ").append(this.logCopyEnabled).append(lineSeparator);
        if (this.waitForServiceList != null) {
            content.append("  ").append("wait.for.service.list").append(" = ").append(this.waitForServiceList).append(lineSeparator);
        }
        if (this.logPath != null) {
            content.append("  ").append("logs.path").append(" = ").append(this.logPath).append(lineSeparator);
        }
        if (this.kubernetesDomain != null) {
            content.append("  ").append("kubernetes.domain").append(" = ").append(this.kubernetesDomain).append(lineSeparator);
        }
        if (this.dockerRegistry != null) {
            content.append("  ").append("docker.registry").append(" = ").append(this.dockerRegistry).append(lineSeparator);
        }
        if (this.apiVersion != null) {
            content.append("  ").append("cube.api.version").append(" = ").append(this.apiVersion).append(lineSeparator);
        }
        if (this.username != null) {
            content.append("  ").append("cube.username").append(" = ").append(this.username).append(lineSeparator);
        }
        if (this.password != null) {
            content.append("  ").append("cube.password").append(" = ").append(this.password).append(lineSeparator);
        }
        if (this.token != null) {
            content.append("  ").append("cube.auth.token").append(" = ").append(this.token).append(lineSeparator);
        }
        content.append("  ").append("cube.trust.certs").append(" = ").append(this.trustCerts).append(lineSeparator);
        return content.toString();
    }
}

