/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.kubernetes.impl.label;

import io.fabric8.kubernetes.clnt.v3_1.KubernetesClient;
import java.util.HashMap;
import java.util.Map;
import org.arquillian.cube.kubernetes.api.LabelProvider;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.spi.Validate;

public class DefaultLabelProvider
implements LabelProvider {
    @Inject
    Instance<KubernetesClient> client;
    private LabelProvider delegate;

    @Override
    public Map<String, String> getLabels() {
        return this.delegate.getLabels();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LabelProvider toImmutable() {
        if (this.delegate != null) {
            return this.delegate;
        }
        DefaultLabelProvider defaultLabelProvider = this;
        synchronized (defaultLabelProvider) {
            if (this.delegate == null) {
                this.delegate = new ImmutableLabelProvider((KubernetesClient)this.client.get());
            }
        }
        return this.delegate;
    }

    public static class ImmutableLabelProvider
    implements LabelProvider {
        private final KubernetesClient client;

        private ImmutableLabelProvider(KubernetesClient client) {
            Validate.notNull((Object)client, (String)"A KubernetesClient instance is required.");
            this.client = client;
        }

        @Override
        public Map<String, String> getLabels() {
            HashMap<String, String> labels = new HashMap<String, String>();
            labels.put("project", this.client.getNamespace());
            labels.put("framework", "arquillian");
            labels.put("component", "integrationTest");
            return labels;
        }

        @Override
        public LabelProvider toImmutable() {
            return this;
        }
    }
}

