/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.openshift.impl.client;

import io.fabric8.kubernetes.clnt.v3_1.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.clnt.v3_1.dsl.Resource;
import io.fabric8.openshift.api.model.v3_1.Route;
import io.fabric8.openshift.api.model.v3_1.RouteList;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Optional;
import org.arquillian.cube.kubernetes.api.Configuration;
import org.arquillian.cube.openshift.impl.client.CubeOpenShiftConfiguration;
import org.arquillian.cube.openshift.impl.client.OpenShiftClient;
import org.jboss.arquillian.core.api.Instance;

public class OpenShiftRouteLocator {
    private Instance<OpenShiftClient> clientInstance;
    private Instance<Configuration> configurationInstance;

    public OpenShiftRouteLocator(Instance<OpenShiftClient> clientInstance, Instance<Configuration> configurationInstance) {
        this.clientInstance = clientInstance;
        this.configurationInstance = configurationInstance;
    }

    public URL getRoute(URL routeUrl) {
        CubeOpenShiftConfiguration config = this.getCubeOpenShiftConfiguration();
        OpenShiftClient client = (OpenShiftClient)this.clientInstance.get();
        String routeName = routeUrl.getHost();
        Route route = (Route)((Resource)((NonNamespaceOperation)client.getClient().routes().inNamespace(config.getNamespace())).withName(routeName)).get();
        if (route == null) {
            return routeUrl;
        }
        return OpenShiftRouteLocator.createUrlFromRoute(route);
    }

    public URL getRoute() {
        CubeOpenShiftConfiguration config = this.getCubeOpenShiftConfiguration();
        OpenShiftClient client = (OpenShiftClient)this.clientInstance.get();
        Optional optionalRoute = ((RouteList)((NonNamespaceOperation)client.getClient().routes().inNamespace(config.getNamespace())).list()).getItems().stream().findFirst();
        return optionalRoute.map(OpenShiftRouteLocator::createUrlFromRoute).orElseThrow(() -> new NullPointerException("No route defined."));
    }

    private CubeOpenShiftConfiguration getCubeOpenShiftConfiguration() {
        CubeOpenShiftConfiguration config = (CubeOpenShiftConfiguration)this.configurationInstance.get();
        if (config == null) {
            throw new NullPointerException("CubeOpenShiftConfiguration is null.");
        }
        return config;
    }

    static URL createUrlFromRoute(Route route) {
        try {
            String protocol = route.getSpec().getTls() == null ? "http" : "https";
            String path = route.getSpec().getPath() == null ? "" : route.getSpec().getPath();
            return new URL(protocol, route.getSpec().getHost(), OpenShiftRouteLocator.resolvePort(protocol), path);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
    }

    private static int resolvePort(String protocol) {
        if ("http".equals(protocol)) {
            return 80;
        }
        return 443;
    }
}

