/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.openshift.impl.ext;

import java.util.List;
import java.util.logging.Logger;
import org.arquillian.cube.openshift.api.model.DeploymentConfig;
import org.arquillian.cube.openshift.api.model.OpenShiftResource;
import org.arquillian.cube.openshift.impl.CEEnvironmentProcessor;
import org.arquillian.cube.openshift.impl.adapter.OpenShiftAdapter;
import org.arquillian.cube.openshift.impl.client.CubeOpenShiftConfiguration;
import org.arquillian.cube.openshift.impl.client.OpenShiftClient;
import org.arquillian.cube.openshift.impl.utils.Operator;
import org.jboss.arquillian.container.spi.event.container.AfterStart;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.test.spi.TestClass;

public class TemplateContainerStarter {
    private final Logger log = Logger.getLogger(TemplateContainerStarter.class.getName());

    public void waitForDeployments(@Observes(precedence=-100) AfterStart event, OpenShiftAdapter client, CEEnvironmentProcessor.TemplateDetails details, TestClass testClass, CubeOpenShiftConfiguration configuration, OpenShiftClient openshiftClient) throws Exception {
        if (testClass == null) {
            return;
        }
        if (details == null) {
            this.log.warning(String.format("No environment for %s", testClass.getName()));
            return;
        }
        this.log.info(String.format("Waiting for environment for %s", testClass.getName()));
        try {
            this.delay(client, details.getResources());
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Error waiting for template resources to deploy: " + testClass.getName(), t);
        }
    }

    private void delay(OpenShiftAdapter client, List<? extends OpenShiftResource> resources) throws Exception {
        for (OpenShiftResource openShiftResource : resources) {
            if (!(openShiftResource instanceof DeploymentConfig)) continue;
            DeploymentConfig dc = (DeploymentConfig)openShiftResource;
            client.delay(dc.getSelector(), dc.getReplicas(), Operator.EQUAL);
        }
    }
}

