/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.openshift.impl.fabric8;

import io.fabric8.kubernetes.api.model.v3_1.Pod;
import io.fabric8.kubernetes.api.model.v3_1.PodCondition;
import io.fabric8.kubernetes.api.model.v3_1.PodList;
import io.fabric8.kubernetes.api.model.v3_1.PodStatus;
import io.fabric8.kubernetes.clnt.v3_1.Adapters;
import io.fabric8.kubernetes.clnt.v3_1.Client;
import io.fabric8.kubernetes.clnt.v3_1.Config;
import io.fabric8.kubernetes.clnt.v3_1.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.clnt.v3_1.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.clnt.v3_1.internal.SSLUtils;
import io.fabric8.openshift.clnt.v3_1.NamespacedOpenShiftClient;
import io.fabric8.openshift.clnt.v3_1.OpenShiftClient;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import okhttp3.OkHttpClient;
import org.arquillian.cube.openshift.impl.client.CubeOpenShiftConfiguration;
import org.arquillian.cube.openshift.impl.proxy.AbstractProxy;
import org.arquillian.cube.openshift.impl.utils.OkHttpClientUtils;

public class F8Proxy
extends AbstractProxy<Pod> {
    private final OpenShiftClient client;
    private OkHttpClient httpClient;

    public F8Proxy(CubeOpenShiftConfiguration configuration, NamespacedOpenShiftClient client) {
        super(configuration);
        this.client = client;
    }

    @Override
    public SSLContext getSSLContext() {
        try {
            return SSLUtils.sslContext((Config)this.client.getConfiguration());
        }
        catch (Throwable t) {
            throw new IllegalStateException(t);
        }
    }

    @Override
    protected synchronized OkHttpClient getHttpClient() {
        if (this.httpClient == null) {
            OkHttpClient okHttpClient = (OkHttpClient)Adapters.get(OkHttpClient.class).adapt((Client)this.client);
            OkHttpClient.Builder builder = okHttpClient.newBuilder();
            OkHttpClientUtils.applyConnectTimeout(builder, this.configuration.getHttpClientTimeout());
            OkHttpClientUtils.applyCookieJar(builder);
            this.httpClient = builder.build();
        }
        return this.httpClient;
    }

    @Override
    protected List<Pod> getPods(Map<String, String> labels) {
        return ((PodList)((FilterWatchListDeletable)((NonNamespaceOperation)this.client.pods().inNamespace(this.configuration.getNamespace())).withLabels(labels)).list()).getItems();
    }

    @Override
    protected String getName(Pod pod) {
        return pod.getMetadata().getName();
    }

    @Override
    protected boolean isReady(Pod pod) {
        List conditions;
        PodStatus status = pod.getStatus();
        if (pod.getMetadata().getDeletionTimestamp() == null && "Running".equalsIgnoreCase(status.getPhase()) && (conditions = status.getConditions()) != null) {
            for (PodCondition condition : conditions) {
                if (!"Ready".equalsIgnoreCase(condition.getType())) continue;
                return "True".equalsIgnoreCase(condition.getStatus());
            }
        }
        return false;
    }
}

