/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.openshift.impl.resources;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.arquillian.cube.openshift.api.Template;
import org.arquillian.cube.openshift.impl.adapter.OpenShiftAdapter;
import org.arquillian.cube.openshift.impl.client.CubeOpenShiftConfiguration;
import org.arquillian.cube.openshift.impl.resources.OpenShiftResourceFactory;
import org.arquillian.cube.openshift.impl.resources.TemplateProcessor;
import org.jboss.arquillian.test.spi.TestClass;

public class ClassTemplateProcessor
extends TemplateProcessor<Class<?>> {
    private static final Logger LOGGER = Logger.getLogger(ClassTemplateProcessor.class.getName());

    public ClassTemplateProcessor(OpenShiftAdapter openShiftAdapter, CubeOpenShiftConfiguration configuration, TestClass testClass) {
        this.openShiftAdapter = openShiftAdapter;
        this.configuration = configuration;
        this.testClass = testClass;
    }

    @Override
    public List<Template> getTemplates() {
        return this.templates;
    }

    @Override
    protected String templateKeyPrefix() {
        return this.testClass.getName();
    }

    @Override
    protected String asynchronousDelayErrorMessage() {
        return "Error waiting for template resources to deploy: " + this.testClass.getName();
    }

    @Override
    protected String noTemplateMessage() {
        return String.format("No template specified for %s", this.testClass.getName());
    }

    @Override
    protected Class<?> getType() {
        return this.testClass.getJavaClass();
    }

    @Override
    protected Map<String, String> scopeLabels() {
        return Collections.singletonMap("test-case", this.testClass.getJavaClass().getSimpleName().toLowerCase());
    }

    @Override
    protected void handleExceptionForCreatingResource() throws Exception {
        OpenShiftResourceFactory.deleteEnvironment(this.testClass, this.openShiftAdapter, this.configuration, this.templates);
    }

    @Override
    protected Logger logger() {
        return LOGGER;
    }
}

