/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.maven.log;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.asciidoctor.log.LogHandler;
import org.asciidoctor.log.LogRecord;
import org.asciidoctor.log.Severity;
import org.asciidoctor.maven.commons.StringUtils;
import org.asciidoctor.maven.log.CapturedLogRecord;

public class MemoryLogHandler
implements LogHandler {
    private final List<LogRecord> records = new ArrayList<LogRecord>();
    private final Boolean outputToConsole;
    private final Consumer<LogRecord> recordConsumer;
    private File currentFile;

    public MemoryLogHandler(Boolean outputToConsole, Consumer<LogRecord> recordConsumer) {
        this.outputToConsole = outputToConsole == null ? Boolean.FALSE : outputToConsole;
        this.recordConsumer = recordConsumer;
    }

    public void log(LogRecord logRecord) {
        CapturedLogRecord record = new CapturedLogRecord(logRecord, this.currentFile);
        this.records.add(record);
        if (this.outputToConsole.booleanValue()) {
            this.recordConsumer.accept(record);
        }
    }

    public void clear() {
        this.records.clear();
    }

    public List<LogRecord> filter(Severity severity) {
        return this.filter(severity, null);
    }

    public List<LogRecord> filter(String text) {
        return this.filter(null, text);
    }

    public List<LogRecord> filter(Severity severity, String text) {
        return this.records.stream().filter((? super T record) -> MemoryLogHandler.severityIsHigher(record, severity) && MemoryLogHandler.messageContains(record, text)).collect(Collectors.toList());
    }

    public boolean isEmpty() {
        return this.records.isEmpty();
    }

    public void processAll() {
        this.records.forEach(this.recordConsumer::accept);
    }

    private static boolean severityIsHigher(LogRecord record, Severity severity) {
        if (severity == null) {
            return true;
        }
        return record.getSeverity().ordinal() >= severity.ordinal();
    }

    private static boolean messageContains(LogRecord record, String text) {
        if (StringUtils.isBlank(text)) {
            return true;
        }
        return record.getMessage().contains(text);
    }

    public void setCurrentFile(File currentFile) {
        this.currentFile = currentFile;
    }
}

