/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.maven.site;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.asciidoctor.ast.Document;
import org.asciidoctor.ast.RevisionInfo;

public class HeaderMetadata {
    private final String title;
    private final List<String> authors;
    private final String dateTime;

    HeaderMetadata(String title, List<String> authors, String dateTime) {
        this.title = title;
        this.authors = authors;
        this.dateTime = dateTime;
    }

    String getTitle() {
        return this.title;
    }

    List<String> getAuthors() {
        return this.authors;
    }

    String getDateTime() {
        return this.dateTime;
    }

    public static HeaderMetadata from(Document document) {
        String title = document.getTitle();
        List<String> authors = HeaderMetadata.extractAuthors(document);
        String documentDateTime = HeaderMetadata.extractDocumentDateTime(document, document.getAttributes());
        return new HeaderMetadata(title, authors, documentDateTime);
    }

    private static List<String> extractAuthors(Document document) {
        return document.getAuthors().stream().map(Object::toString).collect(Collectors.toList());
    }

    private static String extractDocumentDateTime(Document document, Map<String, Object> attributes) {
        RevisionInfo revisionInfo = document.getRevisionInfo();
        return Optional.ofNullable(revisionInfo.getDate()).orElse((String)attributes.get("docdatetime"));
    }
}

