/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.aspectj.weaver.AnnotationAJ;
import org.aspectj.weaver.JoinPointSignatureIterator;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.MemberKind;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedMemberImpl;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.WeaverMessages;
import org.aspectj.weaver.World;

public class MemberImpl
implements Member {
    protected MemberKind kind;
    protected int modifiers;
    protected String name;
    protected UnresolvedType returnType;
    protected UnresolvedType declaringType;
    protected UnresolvedType[] parameterTypes;
    private final String signature;
    private String paramSignature;
    private boolean reportedCantFindDeclaringType = false;
    private boolean reportedUnresolvableMember = false;
    private JoinPointSignatureIterator joinPointSignatures = null;
    private volatile int hashCode = 0;

    public MemberImpl(MemberKind kind, UnresolvedType declaringType, int modifiers, String name, String signature) {
        this.kind = kind;
        this.declaringType = declaringType;
        this.modifiers = modifiers;
        this.name = name;
        this.signature = signature;
        if (kind == Member.FIELD) {
            this.returnType = UnresolvedType.forSignature(signature);
            this.parameterTypes = UnresolvedType.NONE;
        } else {
            Object[] returnAndParams = MemberImpl.signatureToTypes(signature, false);
            this.returnType = (UnresolvedType)returnAndParams[0];
            this.parameterTypes = (UnresolvedType[])returnAndParams[1];
        }
    }

    public MemberImpl(MemberKind kind, UnresolvedType declaringType, int modifiers, UnresolvedType returnType, String name, UnresolvedType[] parameterTypes) {
        this.kind = kind;
        this.declaringType = declaringType;
        this.modifiers = modifiers;
        this.returnType = returnType;
        this.name = name;
        this.parameterTypes = parameterTypes;
        this.signature = kind == Member.FIELD ? returnType.getErasureSignature() : MemberImpl.typesToSignature(returnType, parameterTypes, true);
    }

    public ResolvedMember resolve(World world) {
        return world.resolve(this);
    }

    public static String typesToSignature(UnresolvedType returnType, UnresolvedType[] paramTypes, boolean useRawTypes) {
        StringBuffer buf = new StringBuffer();
        buf.append("(");
        int len = paramTypes.length;
        for (int i = 0; i < len; ++i) {
            if (paramTypes[i].isParameterizedType() && useRawTypes) {
                buf.append(paramTypes[i].getErasureSignature());
                continue;
            }
            if (paramTypes[i].isTypeVariableReference() && useRawTypes) {
                buf.append(paramTypes[i].getErasureSignature());
                continue;
            }
            buf.append(paramTypes[i].getSignature());
        }
        buf.append(")");
        if (returnType.isParameterizedType() && useRawTypes) {
            buf.append(returnType.getErasureSignature());
        } else if (returnType.isTypeVariableReference() && useRawTypes) {
            buf.append(returnType.getErasureSignature());
        } else {
            buf.append(returnType.getSignature());
        }
        return buf.toString();
    }

    public static String typesToSignature(UnresolvedType[] paramTypes) {
        StringBuffer buf = new StringBuffer();
        buf.append("(");
        for (int i = 0; i < paramTypes.length; ++i) {
            buf.append(paramTypes[i].getSignature());
        }
        buf.append(")");
        return buf.toString();
    }

    private static Object[] signatureToTypes(String sig, boolean keepParameterizationInfo) {
        boolean hasParameters;
        boolean bl = hasParameters = sig.charAt(1) != ')';
        if (hasParameters) {
            char c;
            boolean hasAnyAnglies;
            ArrayList<UnresolvedType> l = new ArrayList<UnresolvedType>();
            int i = 1;
            boolean bl2 = hasAnyAnglies = sig.indexOf(60) != -1;
            while ((c = sig.charAt(i)) != ')') {
                int nextSemicolon;
                int start = i;
                while (c == '[') {
                    c = sig.charAt(++i);
                }
                if (c == 'L' || c == 'P') {
                    int firstAngly;
                    nextSemicolon = sig.indexOf(59, start);
                    int n = firstAngly = hasAnyAnglies ? sig.indexOf(60, start) : -1;
                    if (!hasAnyAnglies || firstAngly == -1 || firstAngly > nextSemicolon) {
                        i = nextSemicolon + 1;
                        l.add(UnresolvedType.forSignature(sig.substring(start, i)));
                        continue;
                    }
                    boolean endOfSigReached = false;
                    int posn = firstAngly;
                    int genericDepth = 0;
                    while (!endOfSigReached) {
                        switch (sig.charAt(posn)) {
                            case '<': {
                                ++genericDepth;
                                break;
                            }
                            case '>': {
                                --genericDepth;
                                break;
                            }
                            case ';': {
                                if (genericDepth != 0) break;
                                endOfSigReached = true;
                                break;
                            }
                        }
                        ++posn;
                    }
                    i = posn;
                    l.add(UnresolvedType.forSignature(sig.substring(start, i)));
                    continue;
                }
                if (c == 'T') {
                    nextSemicolon = sig.indexOf(59, start);
                    String nextbit = sig.substring(start, nextSemicolon);
                    l.add(UnresolvedType.forSignature(nextbit));
                    i = nextSemicolon + 1;
                    continue;
                }
                l.add(UnresolvedType.forSignature(sig.substring(start, ++i)));
            }
            UnresolvedType[] paramTypes = l.toArray(new UnresolvedType[l.size()]);
            UnresolvedType returnType = UnresolvedType.forSignature(sig.substring(i + 1, sig.length()));
            return new Object[]{returnType, paramTypes};
        }
        UnresolvedType returnType = UnresolvedType.forSignature(sig.substring(2));
        return new Object[]{returnType, UnresolvedType.NONE};
    }

    public static MemberImpl field(String declaring, int mods, String name, String signature) {
        return MemberImpl.field(declaring, mods, UnresolvedType.forSignature(signature), name);
    }

    public static MemberImpl method(UnresolvedType declaring, int mods, String name, String signature) {
        Object[] pair = MemberImpl.signatureToTypes(signature, false);
        return MemberImpl.method(declaring, mods, (UnresolvedType)pair[0], name, (UnresolvedType[])pair[1]);
    }

    public static MemberImpl monitorEnter() {
        return new MemberImpl(Member.MONITORENTER, UnresolvedType.OBJECT, 8, ResolvedType.VOID, "<lock>", UnresolvedType.ARRAY_WITH_JUST_OBJECT);
    }

    public static MemberImpl monitorExit() {
        return new MemberImpl(Member.MONITOREXIT, UnresolvedType.OBJECT, 8, ResolvedType.VOID, "<unlock>", UnresolvedType.ARRAY_WITH_JUST_OBJECT);
    }

    public static Member pointcut(UnresolvedType declaring, String name, String signature) {
        Object[] pair = MemberImpl.signatureToTypes(signature, false);
        return MemberImpl.pointcut(declaring, 0, (UnresolvedType)pair[0], name, (UnresolvedType[])pair[1]);
    }

    private static MemberImpl field(String declaring, int mods, UnresolvedType ty, String name) {
        return new MemberImpl(Member.FIELD, UnresolvedType.forName(declaring), mods, ty, name, UnresolvedType.NONE);
    }

    public static MemberImpl method(UnresolvedType declTy, int mods, UnresolvedType rTy, String name, UnresolvedType[] paramTys) {
        return new MemberImpl(name.equals("<init>") ? Member.CONSTRUCTOR : Member.METHOD, declTy, mods, rTy, name, paramTys);
    }

    private static Member pointcut(UnresolvedType declTy, int mods, UnresolvedType rTy, String name, UnresolvedType[] paramTys) {
        return new MemberImpl(Member.POINTCUT, declTy, mods, rTy, name, paramTys);
    }

    public static ResolvedMemberImpl makeExceptionHandlerSignature(UnresolvedType inType, UnresolvedType catchType) {
        return new ResolvedMemberImpl(Member.HANDLER, inType, 8, "<catch>", "(" + catchType.getSignature() + ")V");
    }

    public boolean equals(Object other) {
        if (!(other instanceof Member)) {
            return false;
        }
        Member o = (Member)other;
        return this.getKind() == o.getKind() && this.getName().equals(o.getName()) && this.getSignature().equals(o.getSignature()) && this.getDeclaringType().equals(o.getDeclaringType());
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            result = 37 * result + this.getKind().hashCode();
            result = 37 * result + this.getName().hashCode();
            result = 37 * result + this.getSignature().hashCode();
            this.hashCode = result = 37 * result + this.getDeclaringType().hashCode();
        }
        return this.hashCode;
    }

    public int compareTo(Object other) {
        Member o = (Member)other;
        int i = this.getName().compareTo(o.getName());
        if (i != 0) {
            return i;
        }
        return this.getSignature().compareTo(o.getSignature());
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.returnType.getName());
        buf.append(' ');
        buf.append(this.declaringType.getName());
        buf.append('.');
        buf.append(this.name);
        if (this.kind != Member.FIELD) {
            buf.append("(");
            if (this.parameterTypes.length != 0) {
                buf.append(this.parameterTypes[0]);
                int len = this.parameterTypes.length;
                for (int i = 1; i < len; ++i) {
                    buf.append(", ");
                    buf.append(this.parameterTypes[i].getName());
                }
            }
            buf.append(")");
        }
        return buf.toString();
    }

    public MemberKind getKind() {
        return this.kind;
    }

    public UnresolvedType getDeclaringType() {
        return this.declaringType;
    }

    public UnresolvedType getReturnType() {
        return this.returnType;
    }

    public UnresolvedType getGenericReturnType() {
        return this.getReturnType();
    }

    public UnresolvedType[] getGenericParameterTypes() {
        return this.getParameterTypes();
    }

    public final UnresolvedType getType() {
        return this.returnType;
    }

    public String getName() {
        return this.name;
    }

    public UnresolvedType[] getParameterTypes() {
        return this.parameterTypes;
    }

    public String getSignature() {
        return this.signature;
    }

    public int getArity() {
        return this.parameterTypes.length;
    }

    public String getParameterSignature() {
        if (this.paramSignature != null) {
            return this.paramSignature;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        for (int i = 0; i < this.parameterTypes.length; ++i) {
            UnresolvedType tx = this.parameterTypes[i];
            sb.append(tx.getSignature());
        }
        sb.append(")");
        this.paramSignature = sb.toString();
        return this.paramSignature;
    }

    public int getModifiers(World world) {
        ResolvedMember resolved = this.resolve(world);
        if (resolved == null) {
            this.reportDidntFindMember(world);
            return 0;
        }
        return resolved.getModifiers();
    }

    public UnresolvedType[] getExceptions(World world) {
        ResolvedMember resolved = this.resolve(world);
        if (resolved == null) {
            this.reportDidntFindMember(world);
            return UnresolvedType.NONE;
        }
        return resolved.getExceptions();
    }

    public final boolean isStatic() {
        return Modifier.isStatic(this.modifiers);
    }

    public final boolean isInterface() {
        return Modifier.isInterface(this.modifiers);
    }

    public final boolean isPrivate() {
        return Modifier.isPrivate(this.modifiers);
    }

    public boolean canBeParameterized() {
        return false;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public AnnotationAJ[] getAnnotations() {
        throw new UnsupportedOperationException("You should resolve this member '" + this + "' and call getAnnotations() on the result...");
    }

    public Collection getDeclaringTypes(World world) {
        ResolvedType myType = this.getDeclaringType().resolve(world);
        HashSet<ResolvedType> ret = new HashSet<ResolvedType>();
        if (this.kind == Member.CONSTRUCTOR) {
            ret.add(myType);
        } else if (this.isStatic() || this.kind == Member.FIELD) {
            this.walkUpStatic(ret, myType);
        } else {
            this.walkUp(ret, myType);
        }
        return ret;
    }

    private boolean walkUp(Collection acc, ResolvedType curr) {
        if (acc.contains(curr)) {
            return true;
        }
        boolean b = false;
        Iterator i = curr.getDirectSupertypes();
        while (i.hasNext()) {
            b |= this.walkUp(acc, (ResolvedType)i.next());
        }
        if (!b && curr.isParameterizedType()) {
            b = this.walkUp(acc, curr.getGenericType());
        }
        if (!b) {
            boolean bl = b = curr.lookupMemberNoSupers(this) != null;
        }
        if (b) {
            acc.add(curr);
        }
        return b;
    }

    private boolean walkUpStatic(Collection acc, ResolvedType curr) {
        if (curr.lookupMemberNoSupers(this) != null) {
            acc.add(curr);
            return true;
        }
        boolean b = false;
        Iterator i = curr.getDirectSupertypes();
        while (i.hasNext()) {
            b |= this.walkUpStatic(acc, (ResolvedType)i.next());
        }
        if (!b && curr.isParameterizedType()) {
            b = this.walkUpStatic(acc, curr.getGenericType());
        }
        if (b) {
            acc.add(curr);
        }
        return b;
    }

    public String[] getParameterNames(World world) {
        ResolvedMember resolved = this.resolve(world);
        if (resolved == null) {
            this.reportDidntFindMember(world);
            return null;
        }
        return resolved.getParameterNames();
    }

    public Iterator getJoinPointSignatures(World inAWorld) {
        if (this.joinPointSignatures == null) {
            this.joinPointSignatures = new JoinPointSignatureIterator(this, inAWorld);
        }
        this.joinPointSignatures.reset();
        return this.joinPointSignatures;
    }

    private void reportDidntFindMember(World world) {
        if (this.reportedCantFindDeclaringType || this.reportedUnresolvableMember) {
            return;
        }
        ResolvedType rType = this.getDeclaringType().resolve(world);
        if (rType.isMissing()) {
            world.getLint().cantFindType.signal(WeaverMessages.format("cantFindType", rType.getName()), null);
            this.reportedCantFindDeclaringType = true;
        } else {
            world.getLint().unresolvableMember.signal(this.getName(), null);
            this.reportedUnresolvableMember = true;
        }
    }

    public void wipeJoinpointSignatures() {
        this.joinPointSignatures = null;
    }
}

