/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.core.builder;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.aspectj.ajdt.ajc.BuildArgParser;
import org.aspectj.ajdt.internal.compiler.CompilationResultDestinationManager;
import org.aspectj.ajdt.internal.core.builder.AjCompilerOptions;
import org.aspectj.ajdt.internal.core.builder.CompilerConfigurationChangeFlags;
import org.aspectj.util.FileUtil;

public class AjBuildConfig
implements CompilerConfigurationChangeFlags {
    private boolean shouldProceed = true;
    public static final String AJLINT_IGNORE = "ignore";
    public static final String AJLINT_WARN = "warn";
    public static final String AJLINT_ERROR = "error";
    public static final String AJLINT_DEFAULT = "default";
    private File outputDir;
    private File outputJar;
    private String outxmlName;
    private CompilationResultDestinationManager compilationResultDestinationManager = null;
    private List<File> sourceRoots = new ArrayList<File>();
    private List<File> changedFiles;
    private List<File> files = new ArrayList<File>();
    private List<File> xmlfiles = new ArrayList<File>();
    private String processor;
    private String processorPath;
    private List<BinarySourceFile> binaryFiles = new ArrayList<BinarySourceFile>();
    private List<File> inJars = new ArrayList<File>();
    private List<File> inPath = new ArrayList<File>();
    private Map<String, File> sourcePathResources = new HashMap<String, File>();
    private List<File> aspectpath = new ArrayList<File>();
    private List<String> classpath = new ArrayList<String>();
    private List<String> bootclasspath = new ArrayList<String>();
    private List<String> cpElementsWithModifiedContents = new ArrayList<String>();
    private File configFile;
    private String lintMode = "default";
    private Map<String, String> lintOptionsMap = null;
    private File lintSpecFile = null;
    private int changes = 65535;
    private final AjCompilerOptions options;
    private final BuildArgParser buildArgParser;
    private boolean incrementalMode;
    private File incrementalFile;

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("BuildConfig[" + (this.configFile == null ? "null" : this.configFile.getAbsoluteFile().toString()) + "] #Files=" + this.files.size() + " AopXmls=#" + this.xmlfiles.size());
        return sb.toString();
    }

    public AjBuildConfig(BuildArgParser buildArgParser) {
        this.buildArgParser = buildArgParser;
        this.options = new AjCompilerOptions();
    }

    public BuildArgParser getBuildArgParser() {
        return this.buildArgParser;
    }

    public List<File> getFiles() {
        return this.files;
    }

    public List<File> getXmlFiles() {
        return this.xmlfiles;
    }

    public void setProcessor(String processor) {
        this.processor = processor;
    }

    public String getProcessor() {
        return this.processor;
    }

    public void setProcessorPath(String processorPath) {
        this.processorPath = processorPath;
    }

    public String getProcessorPath() {
        return this.processorPath;
    }

    public List<BinarySourceFile> getBinaryFiles() {
        return this.binaryFiles;
    }

    public File getOutputDir() {
        return this.outputDir;
    }

    public CompilationResultDestinationManager getCompilationResultDestinationManager() {
        return this.compilationResultDestinationManager;
    }

    public void setCompilationResultDestinationManager(CompilationResultDestinationManager mgr) {
        this.compilationResultDestinationManager = mgr;
    }

    public void setFiles(List<File> files) {
        this.files = files;
    }

    public void setXmlFiles(List<File> xmlfiles) {
        this.xmlfiles = xmlfiles;
    }

    public void setOutputDir(File outputDir) {
        this.outputDir = outputDir;
    }

    public AjCompilerOptions getOptions() {
        return this.options;
    }

    public List<String> getClasspath() {
        return this.classpath;
    }

    public void setClasspath(List<String> classpath) {
        this.classpath = classpath;
    }

    public List<String> getBootclasspath() {
        return this.bootclasspath;
    }

    public void setBootclasspath(List<String> bootclasspath) {
        this.bootclasspath = bootclasspath;
    }

    public File getOutputJar() {
        return this.outputJar;
    }

    public String getOutxmlName() {
        return this.outxmlName;
    }

    public List<File> getInpath() {
        return this.inPath;
    }

    public List<File> getInJars() {
        return this.inJars;
    }

    public Map<String, File> getSourcePathResources() {
        return this.sourcePathResources;
    }

    public void setOutputJar(File outputJar) {
        this.outputJar = outputJar;
    }

    public void setOutxmlName(String name) {
        this.outxmlName = name;
    }

    public void setInJars(List<File> sourceJars) {
        this.inJars = sourceJars;
    }

    public void setInPath(List<File> dirsOrJars) {
        this.inPath = dirsOrJars;
        this.binaryFiles = new ArrayList<BinarySourceFile>();
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getPath().endsWith(".class");
            }
        };
        for (File inpathElement : dirsOrJars) {
            if (!inpathElement.isDirectory()) continue;
            File[] files = FileUtil.listFiles(inpathElement, filter);
            for (int i = 0; i < files.length; ++i) {
                this.binaryFiles.add(new BinarySourceFile(inpathElement, files[i]));
            }
        }
    }

    public List<File> getSourceRoots() {
        return this.sourceRoots;
    }

    public void setSourceRoots(List<File> sourceRootDir) {
        this.sourceRoots = sourceRootDir;
    }

    public File getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(File configFile) {
        this.configFile = configFile;
    }

    public void setIncrementalMode(boolean incrementalMode) {
        this.incrementalMode = incrementalMode;
    }

    public boolean isIncrementalMode() {
        return this.incrementalMode;
    }

    public void setIncrementalFile(File incrementalFile) {
        this.incrementalFile = incrementalFile;
    }

    public boolean isIncrementalFileMode() {
        return null != this.incrementalFile;
    }

    public List<String> getFullClasspath() {
        ArrayList<String> full = new ArrayList<String>();
        full.addAll(this.getBootclasspath());
        Iterator<File> i = this.inJars.iterator();
        while (i.hasNext()) {
            full.add(i.next().getAbsolutePath());
        }
        i = this.inPath.iterator();
        while (i.hasNext()) {
            full.add(i.next().getAbsolutePath());
        }
        i = this.aspectpath.iterator();
        while (i.hasNext()) {
            full.add(i.next().getAbsolutePath());
        }
        full.addAll(this.getClasspath());
        return full;
    }

    public File getLintSpecFile() {
        return this.lintSpecFile;
    }

    public void setLintSpecFile(File lintSpecFile) {
        this.lintSpecFile = lintSpecFile;
    }

    public List<File> getAspectpath() {
        return this.aspectpath;
    }

    public void setAspectpath(List<File> aspectpath) {
        this.aspectpath = aspectpath;
    }

    public boolean hasSources() {
        return null != this.configFile || 0 < this.sourceRoots.size() || 0 < this.files.size() || 0 < this.inJars.size() || 0 < this.inPath.size();
    }

    public void installGlobals(AjBuildConfig global) {
        this.options.defaultEncoding = global.options.defaultEncoding;
        this.join(this.aspectpath, global.aspectpath);
        this.join(this.classpath, global.classpath);
        if (null == this.configFile) {
            this.configFile = global.configFile;
        }
        if (!this.isEmacsSymMode() && global.isEmacsSymMode()) {
            this.setEmacsSymMode(true);
        }
        this.join(this.files, global.files);
        this.join(this.xmlfiles, global.xmlfiles);
        if (!this.isGenerateModelMode() && global.isGenerateModelMode()) {
            this.setGenerateModelMode(true);
        }
        if (null == this.incrementalFile) {
            this.incrementalFile = global.incrementalFile;
        }
        if (!this.incrementalMode && global.incrementalMode) {
            this.incrementalMode = true;
        }
        if (this.isCheckRuntimeVersion() && !global.isCheckRuntimeVersion()) {
            this.setCheckRuntimeVersion(false);
        }
        this.join(this.inJars, global.inJars);
        this.join(this.inPath, global.inPath);
        if (null == this.lintMode || AJLINT_DEFAULT.equals(this.lintMode)) {
            this.setLintMode(global.lintMode);
        }
        if (null == this.lintSpecFile) {
            this.lintSpecFile = global.lintSpecFile;
        }
        if (!this.isTerminateAfterCompilation() && global.isTerminateAfterCompilation()) {
            this.setTerminateAfterCompilation(true);
        }
        if (null == this.outputDir && null == this.outputJar) {
            if (null != global.outputDir) {
                this.outputDir = global.outputDir;
            }
            if (null != global.outputJar) {
                this.outputJar = global.outputJar;
            }
        }
        this.join(this.sourceRoots, global.sourceRoots);
        if (!this.isXnoInline() && global.isXnoInline()) {
            this.setXnoInline(true);
        }
        if (!this.isXserializableAspects() && global.isXserializableAspects()) {
            this.setXserializableAspects(true);
        }
        if (!this.isXlazyTjp() && global.isXlazyTjp()) {
            this.setXlazyTjp(true);
        }
        if (!this.getProceedOnError() && global.getProceedOnError()) {
            this.setProceedOnError(true);
        }
        this.setTargetAspectjRuntimeLevel(global.getTargetAspectjRuntimeLevel());
        this.setXJoinpoints(global.getXJoinpoints());
        if (!this.isXHasMemberEnabled() && global.isXHasMemberEnabled()) {
            this.setXHasMemberSupport(true);
        }
        if (!this.isXNotReweavable() && global.isXNotReweavable()) {
            this.setXnotReweavable(true);
        }
        this.setOutxmlName(global.getOutxmlName());
        this.setXconfigurationInfo(global.getXconfigurationInfo());
        this.setAddSerialVerUID(global.isAddSerialVerUID());
        if (!this.isXmlConfigured() && global.isXmlConfigured()) {
            this.setXmlConfigured(global.isXmlConfigured());
        }
        this.setTiming(global.isTiming());
        this.setMakeReflectable(global.isMakeReflectable());
    }

    void join(Collection local, Collection global) {
        for (Object next : global) {
            if (local.contains(next)) continue;
            local.add(next);
        }
    }

    public void setSourcePathResources(Map<String, File> map) {
        this.sourcePathResources = map;
    }

    public boolean shouldProceed() {
        return this.shouldProceed;
    }

    public void doNotProceed() {
        this.shouldProceed = false;
    }

    public String getLintMode() {
        return this.lintMode;
    }

    public Map<String, String> getLintOptionsMap() {
        return this.lintOptionsMap;
    }

    public void setLintMode(String lintMode) {
        String lintValue = null;
        this.lintMode = lintMode;
        if (AJLINT_IGNORE.equals(lintMode)) {
            lintValue = AJLINT_IGNORE;
        } else if (AJLINT_WARN.equals(lintMode)) {
            lintValue = "warning";
        } else if (AJLINT_ERROR.equals(lintMode)) {
            lintValue = AJLINT_ERROR;
        } else if (lintMode.indexOf("=") != -1) {
            this.lintMode = AJLINT_DEFAULT;
            this.lintOptionsMap = new HashMap<String, String>();
            StringTokenizer tokenizer = new StringTokenizer(lintMode, ",");
            while (tokenizer.hasMoreElements()) {
                String option = tokenizer.nextToken();
                int equals = option.indexOf("=");
                if (equals == -1) continue;
                String key = option.substring(0, equals);
                String value = option.substring(equals + 1);
                this.lintOptionsMap.put(key, value);
            }
        }
        if (lintValue != null || this.lintOptionsMap != null) {
            HashMap<String, String> lintOptions = new HashMap<String, String>();
            this.setOption("org.aspectj.ajdt.core.compiler.lint.InvalidAbsoluteTypeName", lintValue, lintOptions);
            this.setOption("org.aspectj.ajdt.core.compiler.lint.WildcardTypeName", lintValue, lintOptions);
            this.setOption("org.aspectj.ajdt.core.compiler.lint.UnresolvableMember", lintValue, lintOptions);
            this.setOption("org.aspectj.ajdt.core.compiler.lint.TypeNotExposedToWeaver", lintValue, lintOptions);
            this.setOption("org.aspectj.ajdt.core.compiler.lint.ShadowNotInStructure", lintValue, lintOptions);
            this.setOption("org.aspectj.ajdt.core.compiler.list.UnmatchedSuperTypeInCall", lintValue, lintOptions);
            this.setOption("org.aspectj.ajdt.core.compiler.lint.CannotImplementLazyTJP", lintValue, lintOptions);
            this.setOption("org.aspectj.ajdt.core.compiler.lint.NeedSerialVersionUIDField", lintValue, lintOptions);
            this.setOption("org.aspectj.ajdt.core.compiler.lint.BrokeSerialVersionCompatibility", lintValue, lintOptions);
            this.options.set(lintOptions);
        }
    }

    private void setOption(String optionKey, String lintValue, Map<String, String> lintOptionsAccumulator) {
        if (this.lintOptionsMap != null && this.lintOptionsMap.containsKey(optionKey)) {
            String v = this.lintOptionsMap.get(this.lintOptionsMap);
            if (AJLINT_IGNORE.equals(v)) {
                lintValue = AJLINT_IGNORE;
            } else if (AJLINT_WARN.equals(v)) {
                lintValue = "warning";
            } else if (AJLINT_ERROR.equals(v)) {
                lintValue = AJLINT_ERROR;
            }
        }
        if (lintValue != null) {
            lintOptionsAccumulator.put(optionKey, lintValue);
        }
    }

    public boolean isTerminateAfterCompilation() {
        return this.options.terminateAfterCompilation;
    }

    public void setTerminateAfterCompilation(boolean b) {
        this.options.terminateAfterCompilation = b;
    }

    public boolean isXserializableAspects() {
        return this.options.xSerializableAspects;
    }

    public void setXserializableAspects(boolean xserializableAspects) {
        this.options.xSerializableAspects = xserializableAspects;
    }

    public void setXJoinpoints(String jps) {
        this.options.xOptionalJoinpoints = jps;
    }

    public String getXJoinpoints() {
        return this.options.xOptionalJoinpoints;
    }

    public boolean isXnoInline() {
        return this.options.xNoInline;
    }

    public void setXnoInline(boolean xnoInline) {
        this.options.xNoInline = xnoInline;
    }

    public boolean isXlazyTjp() {
        return this.options.xLazyThisJoinPoint;
    }

    public void setXlazyTjp(boolean b) {
        this.options.xLazyThisJoinPoint = b;
    }

    public void setXnotReweavable(boolean b) {
        this.options.xNotReweavable = b;
    }

    public void setXconfigurationInfo(String info) {
        this.options.xConfigurationInfo = info;
    }

    public String getXconfigurationInfo() {
        return this.options.xConfigurationInfo;
    }

    public void setXHasMemberSupport(boolean enabled) {
        this.options.xHasMember = enabled;
    }

    public boolean isXHasMemberEnabled() {
        return this.options.xHasMember;
    }

    public void setXdevPinpointMode(boolean enabled) {
        this.options.xdevPinpoint = enabled;
    }

    public boolean isXdevPinpoint() {
        return this.options.xdevPinpoint;
    }

    public void setAddSerialVerUID(boolean b) {
        this.options.addSerialVerUID = b;
    }

    public boolean isAddSerialVerUID() {
        return this.options.addSerialVerUID;
    }

    public void setXmlConfigured(boolean b) {
        this.options.xmlConfigured = b;
    }

    public void setMakeReflectable(boolean b) {
        this.options.makeReflectable = b;
    }

    public boolean isXmlConfigured() {
        return this.options.xmlConfigured;
    }

    public boolean isMakeReflectable() {
        return this.options.makeReflectable;
    }

    public boolean isXNotReweavable() {
        return this.options.xNotReweavable;
    }

    public boolean isGenerateJavadocsInModelMode() {
        return this.options.generateJavaDocsInModel;
    }

    public void setGenerateJavadocsInModelMode(boolean generateJavadocsInModelMode) {
        this.options.generateJavaDocsInModel = generateJavadocsInModelMode;
    }

    public boolean isGenerateCrossRefsMode() {
        return this.options.generateCrossRefs;
    }

    public void setGenerateCrossRefsMode(boolean on) {
        this.options.generateCrossRefs = on;
    }

    public boolean isCheckRuntimeVersion() {
        return this.options.checkRuntimeVersion;
    }

    public void setCheckRuntimeVersion(boolean on) {
        this.options.checkRuntimeVersion = on;
    }

    public boolean isEmacsSymMode() {
        return this.options.generateEmacsSymFiles;
    }

    public void setEmacsSymMode(boolean emacsSymMode) {
        this.options.generateEmacsSymFiles = emacsSymMode;
    }

    public boolean isGenerateModelMode() {
        return this.options.generateModel;
    }

    public void setGenerateModelMode(boolean structureModelMode) {
        this.options.generateModel = structureModelMode;
    }

    public boolean isNoAtAspectJAnnotationProcessing() {
        return this.options.noAtAspectJProcessing;
    }

    public void setNoAtAspectJAnnotationProcessing(boolean noProcess) {
        this.options.noAtAspectJProcessing = noProcess;
    }

    public void setShowWeavingInformation(boolean b) {
        this.options.showWeavingInformation = true;
    }

    public boolean getShowWeavingInformation() {
        return this.options.showWeavingInformation;
    }

    public void setProceedOnError(boolean b) {
        this.options.proceedOnError = b;
    }

    public boolean getProceedOnError() {
        return this.options.proceedOnError;
    }

    public void setBehaveInJava5Way(boolean b) {
        this.options.behaveInJava5Way = b;
    }

    public boolean getBehaveInJava5Way() {
        return this.options.behaveInJava5Way;
    }

    public void setTiming(boolean b) {
        this.options.timing = b;
    }

    public boolean isTiming() {
        return this.options.timing;
    }

    public void setTargetAspectjRuntimeLevel(String level) {
        this.options.targetAspectjRuntimeLevel = level;
    }

    public String getTargetAspectjRuntimeLevel() {
        return this.options.targetAspectjRuntimeLevel;
    }

    public void setChanged(int changes) {
        this.changes = changes;
    }

    public int getChanged() {
        return this.changes;
    }

    public void setModifiedFiles(List<File> projectSourceFilesChanged) {
        this.changedFiles = projectSourceFilesChanged;
    }

    public List<File> getModifiedFiles() {
        return this.changedFiles;
    }

    public void setClasspathElementsWithModifiedContents(List<String> cpElementsWithModifiedContents) {
        this.cpElementsWithModifiedContents = cpElementsWithModifiedContents;
    }

    public List<String> getClasspathElementsWithModifiedContents() {
        return this.cpElementsWithModifiedContents;
    }

    public void setProjectEncoding(String projectEncoding) {
        this.options.defaultEncoding = projectEncoding;
    }

    public static class BinarySourceFile {
        public File fromInPathDirectory;
        public File binSrc;

        public BinarySourceFile(File dir, File src) {
            this.fromInPathDirectory = dir;
            this.binSrc = src;
        }

        public boolean equals(Object obj) {
            if (obj != null && obj instanceof BinarySourceFile) {
                BinarySourceFile other = (BinarySourceFile)obj;
                return this.binSrc.equals(other.binSrc);
            }
            return false;
        }

        public int hashCode() {
            return this.binSrc != null ? this.binSrc.hashCode() : 0;
        }
    }
}

