/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core.nd.db;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import org.aspectj.org.eclipse.jdt.internal.core.nd.db.Chunk;
import org.aspectj.org.eclipse.jdt.internal.core.nd.db.ChunkCache;
import org.aspectj.org.eclipse.jdt.internal.core.nd.db.DBStatus;
import org.aspectj.org.eclipse.jdt.internal.core.nd.db.IString;
import org.aspectj.org.eclipse.jdt.internal.core.nd.db.IndexException;
import org.aspectj.org.eclipse.jdt.internal.core.nd.db.LargeBlock;
import org.aspectj.org.eclipse.jdt.internal.core.nd.db.LongString;
import org.aspectj.org.eclipse.jdt.internal.core.nd.db.MemoryStats;
import org.aspectj.org.eclipse.jdt.internal.core.nd.db.Package;
import org.aspectj.org.eclipse.jdt.internal.core.nd.db.ShortString;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class Database {
    public static final int CHAR_SIZE = 2;
    public static final int BYTE_SIZE = 1;
    public static final int SHORT_SIZE = 2;
    public static final int INT_SIZE = 4;
    public static final int LONG_SIZE = 8;
    public static final int CHUNK_SIZE = 4096;
    public static final int OFFSET_IN_CHUNK_MASK = 4095;
    public static final int BLOCK_HEADER_SIZE = 2;
    public static final int BLOCK_SIZE_DELTA_BITS = 3;
    public static final int BLOCK_SIZE_DELTA = 8;
    private static final int BLOCK_PREV_OFFSET = 2;
    private static final int BLOCK_NEXT_OFFSET = 6;
    private static final int FREE_BLOCK_HEADER_SIZE = 10;
    public static final int MIN_BLOCK_DELTAS = 2;
    public static final int MAX_BLOCK_DELTAS = (4096 - LargeBlock.HEADER_SIZE - LargeBlock.FOOTER_SIZE) / 8;
    public static final int MAX_SINGLE_BLOCK_MALLOC_SIZE = MAX_BLOCK_DELTAS * 8 - 2;
    public static final int PTR_SIZE = 4;
    public static final int STRING_SIZE = 4;
    public static final int FLOAT_SIZE = 4;
    public static final int DOUBLE_SIZE = 8;
    public static final long MAX_DB_SIZE = 0x800000000L;
    public static final long MAX_MALLOC_SIZE = 0x800000000L - (long)LargeBlock.HEADER_SIZE - (long)LargeBlock.FOOTER_SIZE - 4096L - 2L;
    public static final int VERSION_OFFSET = 0;
    public static final int MALLOC_TABLE_OFFSET = 4;
    public static final int FREE_BLOCK_OFFSET = 2048;
    public static final int WRITE_NUMBER_OFFSET = 2052;
    public static final int MALLOC_STATS_OFFSET = 2060;
    public static final int DATA_AREA_OFFSET = 2060 + MemoryStats.SIZE;
    public static final short POOL_MISC = 0;
    public static final short POOL_BTREE = 1;
    public static final short POOL_DB_PROPERTIES = 2;
    public static final short POOL_STRING_LONG = 3;
    public static final short POOL_STRING_SHORT = 4;
    public static final short POOL_LINKED_LIST = 5;
    public static final short POOL_STRING_SET = 6;
    public static final short POOL_GROWABLE_ARRAY = 7;
    public static final short POOL_FIRST_NODE_TYPE = 256;
    private final File fLocation;
    private final boolean fReadOnly;
    private RandomAccessFile fFile;
    private boolean fExclusiveLock;
    private boolean fLocked;
    private boolean fIsMarkedIncomplete;
    private int fVersion;
    private final Chunk fHeaderChunk;
    private Chunk[] fChunks;
    private int fChunksUsed;
    private ChunkCache fCache;
    private long malloced;
    private long freed;
    private long cacheHits;
    private long cacheMisses;
    private MemoryStats memoryUsage;

    public Database(File location, ChunkCache cache, int version, boolean openReadOnly) throws IndexException {
        try {
            this.fLocation = location;
            this.fReadOnly = openReadOnly;
            this.fCache = cache;
            this.openFile();
            int nChunksOnDisk = (int)(this.fFile.length() / 4096L);
            this.fHeaderChunk = new Chunk(this, 0);
            this.fHeaderChunk.fLocked = true;
            if (nChunksOnDisk <= 0) {
                this.fVersion = version;
                this.fChunks = new Chunk[1];
                this.fChunksUsed = this.fChunks.length;
            } else {
                this.fHeaderChunk.read();
                this.fVersion = this.fHeaderChunk.getInt(0L);
                this.fChunks = new Chunk[nChunksOnDisk];
                this.fChunksUsed = nChunksOnDisk;
            }
        }
        catch (IOException e) {
            throw new IndexException(new DBStatus(e));
        }
        this.memoryUsage = new MemoryStats(this.fHeaderChunk, 2060L);
    }

    private static int divideRoundingUp(long num, int den) {
        return (int)((num + (long)den - 1L) / (long)den);
    }

    private void openFile() throws FileNotFoundException {
        this.fFile = new RandomAccessFile(this.fLocation, this.fReadOnly ? "r" : "rw");
    }

    void read(ByteBuffer buf, long position) throws IOException {
        int retries = 0;
        while (true) {
            try {
                this.fFile.getChannel().read(buf, position);
                return;
            }
            catch (ClosedChannelException e) {
                this.openFile();
                if (!(e instanceof ClosedByInterruptException)) continue;
                throw new OperationCanceledException();
                if (++retries < 20) continue;
                throw e;
            }
            break;
        }
    }

    boolean write(ByteBuffer buf, long position) throws IOException {
        return this.performUninterruptableWrite(() -> this.fFile.getChannel().write(buf, position));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean performUninterruptableWrite(IORunnable runnable) throws IOException {
        boolean interrupted = false;
        int retries = 0;
        while (true) {
            try {
                runnable.run();
                return interrupted;
            }
            catch (ClosedChannelException e) {
                this.openFile();
                if (e instanceof ClosedByInterruptException) {
                    interrupted = true;
                    continue;
                }
                if (++retries > 20) throw e;
                continue;
            }
            break;
        }
    }

    public void transferTo(FileChannel target) throws IOException {
        assert (this.fLocked);
        FileChannel from = this.fFile.getChannel();
        long nRead = 0L;
        long position = 0L;
        long size = from.size();
        while (position < size) {
            nRead = from.transferTo(position, 65536L, target);
            if (nRead == 0L) break;
            position += nRead;
        }
    }

    public int getVersion() {
        return this.fVersion;
    }

    public void setVersion(int version) throws IndexException {
        assert (this.fExclusiveLock);
        this.fHeaderChunk.putInt(0L, version);
        this.fVersion = version;
    }

    public boolean clear(int version) throws IndexException {
        assert (this.fExclusiveLock);
        boolean wasCanceled = false;
        this.removeChunksFromCache();
        this.fVersion = version;
        this.fHeaderChunk.clear(0L, 4096);
        this.fChunks = new Chunk[1];
        this.fChunksUsed = this.fChunks.length;
        try {
            wasCanceled = this.fHeaderChunk.flush() || wasCanceled;
            wasCanceled = this.performUninterruptableWrite(() -> this.fFile.getChannel().truncate(4096L)) || wasCanceled;
        }
        catch (IOException e) {
            Package.log(e);
        }
        this.freed = 0L;
        this.malloced = 0L;
        long setasideChunks = Long.getLong("org.aspectj.org.eclipse.jdt.core.parser.nd.chunks", 0L);
        if (setasideChunks != 0L) {
            this.setVersion(this.getVersion());
            this.createNewChunks((int)setasideChunks);
            wasCanceled = this.flush() || wasCanceled;
        }
        this.memoryUsage.refresh();
        return wasCanceled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeChunksFromCache() {
        ChunkCache chunkCache = this.fCache;
        synchronized (chunkCache) {
            int i = 1;
            while (i < this.fChunks.length) {
                Chunk chunk = this.fChunks[i];
                if (chunk != null) {
                    this.fCache.remove(chunk);
                    this.fChunks[i] = null;
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Chunk getChunk(long offset) throws IndexException {
        this.assertLocked();
        if (offset < 4096L) {
            return this.fHeaderChunk;
        }
        long long_index = offset / 4096L;
        assert (long_index < Integer.MAX_VALUE);
        ChunkCache chunkCache = this.fCache;
        synchronized (chunkCache) {
            Chunk chunk;
            assert (this.fLocked);
            int index = (int)long_index;
            if (index < 0 || index >= this.fChunks.length) {
                this.databaseCorruptionDetected();
            }
            if ((chunk = this.fChunks[index]) == null) {
                ++this.cacheMisses;
                chunk = new Chunk(this, index);
                chunk.read();
                this.fChunks[index] = chunk;
            } else {
                ++this.cacheHits;
            }
            this.fCache.add(chunk, this.fExclusiveLock);
            return chunk;
        }
    }

    public void assertLocked() {
        if (!this.fLocked) {
            throw new IllegalStateException("Database not locked!");
        }
    }

    private void databaseCorruptionDetected() throws IndexException {
        String msg = "Corrupted database: " + this.fLocation.getName();
        throw new IndexException(new DBStatus(msg));
    }

    public void memcpy(long dest, long source, int numBytes) {
        assert (numBytes >= 0);
        assert (numBytes <= MAX_SINGLE_BLOCK_MALLOC_SIZE);
        int count = 0;
        while (count < numBytes) {
            this.putByte(dest + (long)count, this.getByte(source + (long)count));
            ++count;
        }
    }

    public long malloc(long datasize, short poolId) throws IndexException {
        long result;
        int usedSize;
        assert (this.fExclusiveLock);
        assert (datasize >= 0L);
        assert (datasize <= MAX_MALLOC_SIZE);
        if (datasize >= (long)MAX_SINGLE_BLOCK_MALLOC_SIZE) {
            int newChunkNum = this.createLargeBlock(datasize);
            usedSize = Math.abs(this.getBlockHeaderForChunkNum(newChunkNum)) * 4096;
            result = newChunkNum * 4096 + LargeBlock.HEADER_SIZE;
            this.clearRange(result, usedSize - LargeBlock.HEADER_SIZE - LargeBlock.FOOTER_SIZE);
            result += 2L;
        } else {
            Chunk chunk;
            long freeBlock = 0L;
            int needDeltas = Database.divideRoundingUp(datasize + 2L, 8);
            if (needDeltas < 2) {
                needDeltas = 2;
            }
            int useDeltas = needDeltas;
            while (useDeltas <= MAX_BLOCK_DELTAS) {
                freeBlock = this.getFirstBlock(useDeltas * 8);
                if (freeBlock != 0L) break;
                ++useDeltas;
            }
            if (freeBlock == 0L) {
                freeBlock = (long)this.createLargeBlock(datasize) * 4096L + (long)LargeBlock.HEADER_SIZE;
                useDeltas = MAX_BLOCK_DELTAS;
                chunk = this.getChunk(freeBlock);
            } else {
                chunk = this.getChunk(freeBlock);
                this.removeBlock(chunk, useDeltas * 8, freeBlock);
            }
            int unusedDeltas = useDeltas - needDeltas;
            if (unusedDeltas >= 2) {
                this.addBlock(chunk, unusedDeltas * 8, freeBlock + (long)(needDeltas * 8));
                useDeltas = needDeltas;
            }
            usedSize = useDeltas * 8;
            chunk.putShort(freeBlock, (short)(-usedSize));
            chunk.clear(freeBlock + 2L, usedSize - 2);
            result = freeBlock + 2L;
        }
        this.malloced += (long)usedSize;
        this.memoryUsage.recordMalloc(poolId, usedSize);
        return result;
    }

    public void clearRange(long startAddress, int bytesToClear) {
        Chunk nextBlock;
        if (bytesToClear == 0) {
            return;
        }
        long endAddress = startAddress + (long)bytesToClear;
        assert (endAddress <= (long)(this.fChunksUsed * 4096));
        int blockNumber = (int)(startAddress / 4096L);
        int firstBlockBytesToClear = Math.min((int)((long)((blockNumber + 1) * 4096) - startAddress), bytesToClear);
        Chunk firstBlock = this.getChunk(startAddress);
        firstBlock.clear(startAddress, firstBlockBytesToClear);
        startAddress += (long)firstBlockBytesToClear;
        bytesToClear -= firstBlockBytesToClear;
        while (bytesToClear > 4096) {
            nextBlock = this.getChunk(startAddress);
            nextBlock.clear(startAddress, 4096);
            startAddress += 4096L;
            bytesToClear -= 4096;
        }
        if (bytesToClear > 0) {
            nextBlock = this.getChunk(startAddress);
            nextBlock.clear(startAddress, bytesToClear);
        }
    }

    private int createLargeBlock(long datasize) {
        int resultChunkNum;
        int numChunks;
        int neededChunks = Database.getChunksNeededForBytes(datasize);
        int freeBlockChunkNum = this.getFreeBlockFromTrie(neededChunks);
        if (freeBlockChunkNum == 0) {
            int lastChunkNum = this.fChunksUsed;
            numChunks = neededChunks;
            int lastBlockSize = this.getBlockFooterForChunkBefore(lastChunkNum);
            if (lastBlockSize > 0) {
                int startChunkNum = this.getFirstChunkOfBlockBefore(lastChunkNum);
                this.unlinkFreeBlock(startChunkNum);
                this.createNewChunks(neededChunks - lastBlockSize);
                freeBlockChunkNum = startChunkNum;
            } else {
                freeBlockChunkNum = this.createNewChunks(numChunks);
            }
        } else {
            numChunks = this.getBlockHeaderForChunkNum(freeBlockChunkNum);
            this.unlinkFreeBlock(freeBlockChunkNum);
        }
        if (numChunks > neededChunks) {
            long nextBlockChunkNum = freeBlockChunkNum + numChunks;
            int nextBlockSize = Math.abs(this.getBlockHeaderForChunkNum(nextBlockChunkNum));
            int prevBlockSize = Math.abs(this.getBlockFooterForChunkBefore(freeBlockChunkNum));
            int unusedChunks = numChunks - neededChunks;
            if (nextBlockSize >= prevBlockSize) {
                resultChunkNum = freeBlockChunkNum;
                this.linkFreeBlockToTrie(freeBlockChunkNum + neededChunks, unusedChunks);
            } else {
                resultChunkNum = freeBlockChunkNum + neededChunks;
                this.linkFreeBlockToTrie(freeBlockChunkNum, unusedChunks);
            }
        } else {
            resultChunkNum = freeBlockChunkNum;
        }
        this.setBlockHeader(resultChunkNum, -neededChunks);
        return resultChunkNum;
    }

    private void unlinkFreeBlock(int freeBlockChunkNum) {
        int currentSize;
        int difference;
        long root;
        long freeBlockAddress = freeBlockChunkNum * 4096;
        int anotherBlockOfSameSize = 0;
        int nextBlockChunkNum = this.getInt(freeBlockAddress + (long)LargeBlock.NEXT_BLOCK_OFFSET);
        int prevBlockChunkNum = this.getInt(freeBlockAddress + (long)LargeBlock.PREV_BLOCK_OFFSET);
        if (nextBlockChunkNum != 0) {
            anotherBlockOfSameSize = nextBlockChunkNum;
            this.putInt(nextBlockChunkNum * 4096 + LargeBlock.PREV_BLOCK_OFFSET, prevBlockChunkNum);
        }
        if (prevBlockChunkNum != 0) {
            anotherBlockOfSameSize = prevBlockChunkNum;
            this.putInt(prevBlockChunkNum * 4096 + LargeBlock.NEXT_BLOCK_OFFSET, nextBlockChunkNum);
        }
        if ((root = (long)this.getInt(2048L)) == (long)freeBlockChunkNum) {
            this.putInt(2048L, 0);
        }
        int freeBlockSize = this.getBlockHeaderForChunkNum(freeBlockChunkNum);
        int parentChunkNum = this.getInt(freeBlockAddress + (long)LargeBlock.PARENT_OFFSET);
        if (parentChunkNum != 0 && (difference = (currentSize = this.getBlockHeaderForChunkNum(parentChunkNum)) ^ freeBlockSize) != 0) {
            int firstDifference = 32 - Integer.numberOfLeadingZeros(difference) - 1;
            long locationOfChildPointer = parentChunkNum * 4096 + LargeBlock.CHILD_TABLE_OFFSET + firstDifference * 4;
            this.putInt(locationOfChildPointer, 0);
        }
        if (anotherBlockOfSameSize != 0) {
            this.insertChild(parentChunkNum, anotherBlockOfSameSize);
        }
        int currentParent = parentChunkNum;
        int childIdx = 0;
        while (childIdx < 32) {
            int nextChildChunkNum = this.getInt(freeBlockAddress + (long)LargeBlock.CHILD_TABLE_OFFSET + (long)(childIdx * 4));
            if (nextChildChunkNum != 0) {
                this.insertChild(currentParent, nextChildChunkNum);
                if (currentParent == parentChunkNum) {
                    currentParent = nextChildChunkNum;
                }
            }
            ++childIdx;
        }
    }

    private int getFreeBlockFromTrie(int numChunks) {
        int currentChunkNum = this.getInt(2048L);
        int resultChunkNum = this.getSmallestChildNoSmallerThan(currentChunkNum, numChunks);
        if (resultChunkNum == 0) {
            return 0;
        }
        int nextResultChunkNum = this.getInt(resultChunkNum * 4096 + LargeBlock.NEXT_BLOCK_OFFSET);
        if (nextResultChunkNum != 0) {
            return nextResultChunkNum;
        }
        return resultChunkNum;
    }

    private int getSmallestChildNoSmallerThan(int trieNodeChunkNum, int numChunks) {
        if (trieNodeChunkNum == 0) {
            return 0;
        }
        int currentSize = this.getBlockHeaderForChunkNum(trieNodeChunkNum);
        assert (currentSize >= 0);
        int difference = currentSize ^ numChunks;
        if (difference == 0) {
            return trieNodeChunkNum;
        }
        int bitMask = Integer.highestOneBit(difference);
        int firstDifference = 32 - Integer.numberOfLeadingZeros(bitMask) - 1;
        boolean lookingForSmallerChild = currentSize > numChunks;
        int testPosition = firstDifference;
        while (testPosition < 32) {
            int nextChildChunkNum;
            int childResultChunkNum;
            if ((currentSize & bitMask) != 0 == lookingForSmallerChild && (childResultChunkNum = this.getSmallestChildNoSmallerThan(nextChildChunkNum = this.getInt(trieNodeChunkNum * 4096 + LargeBlock.CHILD_TABLE_OFFSET + testPosition * 4), numChunks)) != 0) {
                return childResultChunkNum;
            }
            bitMask <<= 1;
            ++testPosition;
        }
        if (lookingForSmallerChild) {
            return trieNodeChunkNum;
        }
        return 0;
    }

    private void linkFreeBlockToTrie(int freeBlockChunkNum, int numChunks) {
        this.setBlockHeader(freeBlockChunkNum, numChunks);
        long freeBlockAddress = freeBlockChunkNum * 4096;
        Chunk chunk = this.getChunk(freeBlockAddress);
        chunk.clear(freeBlockAddress + (long)LargeBlock.HEADER_SIZE, LargeBlock.UNALLOCATED_HEADER_SIZE - LargeBlock.HEADER_SIZE);
        this.insertChild(this.getInt(2048L), freeBlockChunkNum);
    }

    private void insertChild(int parentChunkNum, int newChildChunkNum) {
        if (parentChunkNum == 0) {
            this.putInt(newChildChunkNum * 4096 + LargeBlock.PARENT_OFFSET, parentChunkNum);
            this.putInt(2048L, newChildChunkNum);
            return;
        }
        int numChunks = this.getBlockHeaderForChunkNum(newChildChunkNum);
        while (true) {
            int currentSize;
            int difference;
            if ((difference = (currentSize = this.getBlockHeaderForChunkNum(parentChunkNum)) ^ numChunks) == 0) {
                this.insertFreeBlockAfter(parentChunkNum, newChildChunkNum);
                return;
            }
            int firstDifference = 32 - Integer.numberOfLeadingZeros(difference) - 1;
            long locationOfChildPointer = parentChunkNum * 4096 + LargeBlock.CHILD_TABLE_OFFSET + firstDifference * 4;
            int childChunkNum = this.getInt(locationOfChildPointer);
            if (childChunkNum == 0) {
                this.putInt(locationOfChildPointer, newChildChunkNum);
                this.putInt(newChildChunkNum * 4096 + LargeBlock.PARENT_OFFSET, parentChunkNum);
                return;
            }
            parentChunkNum = childChunkNum;
        }
    }

    private void insertFreeBlockAfter(int prevChunkNum, int newChunkNum) {
        long prevChunkAddress = (long)prevChunkNum * 4096L;
        int nextChunkNum = this.getInt(prevChunkAddress + (long)LargeBlock.NEXT_BLOCK_OFFSET);
        long nextChunkAddress = (long)nextChunkNum * 4096L;
        long newLockAddress = (long)newChunkNum * 4096L;
        this.putInt(prevChunkAddress + (long)LargeBlock.NEXT_BLOCK_OFFSET, newChunkNum);
        if (nextChunkNum != 0) {
            this.putInt(nextChunkAddress + (long)LargeBlock.PREV_BLOCK_OFFSET, newChunkNum);
        }
        this.putInt(newLockAddress + (long)LargeBlock.PREV_BLOCK_OFFSET, prevChunkNum);
        this.putInt(newLockAddress + (long)LargeBlock.NEXT_BLOCK_OFFSET, nextChunkNum);
    }

    private int getFirstChunkOfBlockBefore(int chunkNum) {
        int blockChunks = Math.abs(this.getBlockFooterForChunkBefore(chunkNum));
        return chunkNum - blockChunks;
    }

    private void setBlockHeader(int firstChunkNum, int headerContent) {
        assert (headerContent != 0);
        assert (firstChunkNum < this.fChunksUsed);
        int numBlocks = Math.abs(headerContent);
        long firstChunkAddress = firstChunkNum * 4096;
        this.putInt(firstChunkAddress, headerContent);
        this.putInt(firstChunkAddress + (long)(numBlocks * 4096) - (long)LargeBlock.FOOTER_SIZE, headerContent);
    }

    private int getBlockHeaderForChunkNum(long firstChunkNum) {
        if (firstChunkNum >= (long)this.fChunksUsed) {
            return 0;
        }
        return this.getInt(firstChunkNum * 4096L);
    }

    private int getBlockFooterForChunkBefore(int chunkNum) {
        if (chunkNum < 2) {
            return 0;
        }
        return this.getInt(chunkNum * 4096 - LargeBlock.FOOTER_SIZE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int createNewChunks(int numChunks) throws IndexException {
        assert (this.fExclusiveLock);
        ChunkCache chunkCache = this.fCache;
        synchronized (chunkCache) {
            int firstChunkIndex = this.fChunksUsed;
            int lastChunkIndex = firstChunkIndex + numChunks - 1;
            Chunk lastChunk = new Chunk(this, lastChunkIndex);
            lastChunk.fDirty = true;
            if (lastChunkIndex >= this.fChunks.length) {
                int increment = Math.max(1024, this.fChunks.length / 20);
                int newNumChunks = Math.max(lastChunkIndex + 1, this.fChunks.length + increment);
                Chunk[] newChunks = new Chunk[newNumChunks];
                System.arraycopy(this.fChunks, 0, newChunks, 0, this.fChunks.length);
                this.fChunks = newChunks;
            }
            this.fChunksUsed = lastChunkIndex + 1;
            this.fChunks[lastChunkIndex] = lastChunk;
            this.fCache.add(lastChunk, true);
            long result = (long)firstChunkIndex * 4096L;
            long endAddress = result + (long)(numChunks * 4096);
            if (endAddress > 0x800000000L) {
                Object[] bindings = new Object[]{this.getLocation().getAbsolutePath(), 0x800000000L};
                throw new IndexException(new Status(4, Package.PLUGIN_ID, 4, NLS.bind("Database too large! Address = " + endAddress + ", max size = " + 0x800000000L, bindings), null));
            }
            return firstChunkIndex;
        }
    }

    private long getFirstBlock(int blocksize) throws IndexException {
        assert (this.fLocked);
        return this.fHeaderChunk.getFreeRecPtr(4 + (blocksize / 8 - 2) * 4);
    }

    private void setFirstBlock(int blocksize, long block) throws IndexException {
        assert (this.fExclusiveLock);
        this.fHeaderChunk.putFreeRecPtr(4 + (blocksize / 8 - 2) * 4, block);
    }

    private void removeBlock(Chunk chunk, int blocksize, long block) throws IndexException {
        assert (this.fExclusiveLock);
        long prevblock = chunk.getFreeRecPtr(block + 2L);
        long nextblock = chunk.getFreeRecPtr(block + 6L);
        if (prevblock != 0L) {
            this.putFreeRecPtr(prevblock + 6L, nextblock);
        } else {
            this.setFirstBlock(blocksize, nextblock);
        }
        if (nextblock != 0L) {
            this.putFreeRecPtr(nextblock + 2L, prevblock);
        }
    }

    private void addBlock(Chunk chunk, int blocksize, long block) throws IndexException {
        assert (this.fExclusiveLock);
        chunk.putShort(block, (short)blocksize);
        long prevfirst = this.getFirstBlock(blocksize);
        chunk.putFreeRecPtr(block + 2L, 0L);
        chunk.putFreeRecPtr(block + 6L, prevfirst);
        if (prevfirst != 0L) {
            this.putFreeRecPtr(prevfirst + 2L, block);
        }
        this.setFirstBlock(blocksize, block);
    }

    public void free(long address, short poolId) throws IndexException {
        assert (this.fExclusiveLock);
        if (address == 0L) {
            return;
        }
        long block = address - 2L;
        Chunk chunk = this.getChunk(block);
        long blockSize = -chunk.getShort(block);
        if (blockSize == 0L) {
            int offsetIntoChunk = (int)(address % 4096L);
            assert (offsetIntoChunk == LargeBlock.HEADER_SIZE + 2);
            int chunkNum = (int)(address / 4096L);
            int numChunks = -this.getBlockHeaderForChunkNum(chunkNum);
            if (numChunks < 0) {
                throw new IndexException(new Status(4, Package.PLUGIN_ID, 0, "Already freed large block " + address, new Exception()));
            }
            blockSize = numChunks * 4096;
            this.freeLargeChunk(chunkNum, numChunks);
        } else {
            if (blockSize < 0L) {
                throw new IndexException(new Status(4, Package.PLUGIN_ID, 0, "Already freed record " + address, new Exception()));
            }
            this.addBlock(chunk, (int)blockSize, block);
        }
        this.freed += blockSize;
        this.memoryUsage.recordFree(poolId, blockSize);
    }

    private void freeLargeChunk(int chunkNum, int numChunks) {
        assert (chunkNum > 0);
        assert (numChunks > 0);
        int prevBlockHeader = this.getBlockFooterForChunkBefore(chunkNum);
        int nextBlockChunkNum = chunkNum + numChunks;
        int nextBlockHeader = this.getBlockHeaderForChunkNum(nextBlockChunkNum);
        if (prevBlockHeader > 0) {
            int prevBlockChunkNum = this.getFirstChunkOfBlockBefore(chunkNum);
            this.unlinkFreeBlock(prevBlockChunkNum);
            chunkNum = prevBlockChunkNum;
            numChunks += prevBlockHeader;
        }
        if (nextBlockHeader > 0) {
            this.unlinkFreeBlock(nextBlockChunkNum);
            numChunks += nextBlockHeader;
        }
        this.linkFreeBlockToTrie(chunkNum, numChunks);
    }

    public void putByte(long offset, byte value) throws IndexException {
        this.getChunk(offset).putByte(offset, value);
    }

    public byte getByte(long offset) throws IndexException {
        return this.getChunk(offset).getByte(offset);
    }

    public void putInt(long offset, int value) throws IndexException {
        this.getChunk(offset).putInt(offset, value);
    }

    public int getInt(long offset) throws IndexException {
        return this.getChunk(offset).getInt(offset);
    }

    public void putRecPtr(long offset, long value) throws IndexException {
        this.getChunk(offset).putRecPtr(offset, value);
    }

    public long getRecPtr(long offset) throws IndexException {
        return this.getChunk(offset).getRecPtr(offset);
    }

    private void putFreeRecPtr(long offset, long value) throws IndexException {
        this.getChunk(offset).putFreeRecPtr(offset, value);
    }

    private long getFreeRecPtr(long offset) throws IndexException {
        return this.getChunk(offset).getFreeRecPtr(offset);
    }

    public void put3ByteUnsignedInt(long offset, int value) throws IndexException {
        this.getChunk(offset).put3ByteUnsignedInt(offset, value);
    }

    public int get3ByteUnsignedInt(long offset) throws IndexException {
        return this.getChunk(offset).get3ByteUnsignedInt(offset);
    }

    public void putShort(long offset, short value) throws IndexException {
        this.getChunk(offset).putShort(offset, value);
    }

    public short getShort(long offset) throws IndexException {
        return this.getChunk(offset).getShort(offset);
    }

    public void putLong(long offset, long value) throws IndexException {
        this.getChunk(offset).putLong(offset, value);
    }

    public void putDouble(long offset, double value) throws IndexException {
        this.getChunk(offset).putDouble(offset, value);
    }

    public void putFloat(long offset, float value) throws IndexException {
        this.getChunk(offset).putFloat(offset, value);
    }

    public long getLong(long offset) throws IndexException {
        return this.getChunk(offset).getLong(offset);
    }

    public double getDouble(long offset) throws IndexException {
        return this.getChunk(offset).getDouble(offset);
    }

    public float getFloat(long offset) throws IndexException {
        return this.getChunk(offset).getFloat(offset);
    }

    public void putChar(long offset, char value) throws IndexException {
        this.getChunk(offset).putChar(offset, value);
    }

    public char getChar(long offset) throws IndexException {
        return this.getChunk(offset).getChar(offset);
    }

    public void clearBytes(long offset, int byteCount) throws IndexException {
        this.getChunk(offset).clear(offset, byteCount);
    }

    public void putBytes(long offset, byte[] data, int len) throws IndexException {
        this.getChunk(offset).put(offset, data, len);
    }

    public void putBytes(long offset, byte[] data, int dataPos, int len) throws IndexException {
        this.getChunk(offset).put(offset, data, dataPos, len);
    }

    public void getBytes(long offset, byte[] data) throws IndexException {
        this.getChunk(offset).get(offset, data);
    }

    public void getBytes(long offset, byte[] data, int dataPos, int len) throws IndexException {
        this.getChunk(offset).get(offset, data, dataPos, len);
    }

    public IString newString(String string) throws IndexException {
        return this.newString(string.toCharArray());
    }

    public IString newString(char[] chars) throws IndexException {
        int len = chars.length;
        boolean useBytes = this.useBytes(chars);
        int bytelen = useBytes ? len : 2 * len;
        if (bytelen > ShortString.MAX_BYTE_LENGTH) {
            return new LongString(this, chars, useBytes);
        }
        return new ShortString(this, chars, useBytes);
    }

    private boolean useBytes(char[] chars) {
        char[] cArray = chars;
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if ((c & 0xFF00) != 0) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public IString getString(long offset) throws IndexException {
        int bytelen;
        int l = this.getInt(offset);
        int n = bytelen = l < 0 ? -l : 2 * l;
        if (bytelen > ShortString.MAX_BYTE_LENGTH) {
            return new LongString(this, offset);
        }
        return new ShortString(this, offset);
    }

    public long getDatabaseSize() {
        return this.fChunksUsed * 4096;
    }

    public void reportFreeBlocks() throws IndexException {
        System.out.println("Allocated size: " + this.getDatabaseSize() + " bytes");
        System.out.println("malloc'ed: " + this.malloced);
        System.out.println("free'd: " + this.freed);
        System.out.println("wasted: " + (this.getDatabaseSize() - (this.malloced - this.freed)));
        System.out.println("Free blocks");
        int bs = 16;
        while (bs <= 4096) {
            int count = 0;
            long block = this.getFirstBlock(bs);
            while (block != 0L) {
                ++count;
                block = this.getFreeRecPtr(block + 6L);
            }
            if (count != 0) {
                System.out.println("Block size: " + bs + "=" + count);
            }
            bs += 8;
        }
    }

    public void close() throws IndexException {
        assert (this.fExclusiveLock);
        this.flush();
        this.removeChunksFromCache();
        this.fHeaderChunk.clear(0L, 4096);
        this.memoryUsage.refresh();
        this.fHeaderChunk.fDirty = false;
        this.fChunks = new Chunk[1];
        this.fChunksUsed = this.fChunks.length;
        try {
            this.fFile.close();
        }
        catch (IOException e) {
            throw new IndexException(new DBStatus(e));
        }
    }

    public File getLocation() {
        return this.fLocation;
    }

    void releaseChunk(Chunk chunk) {
        if (!chunk.fLocked) {
            this.fChunks[chunk.fSequenceNumber] = null;
        }
    }

    public ChunkCache getChunkCache() {
        return this.fCache;
    }

    public void setExclusiveLock() {
        this.fExclusiveLock = true;
        this.fLocked = true;
    }

    public void setLocked(boolean val) {
        this.fLocked = val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean giveUpExclusiveLock(boolean flush) throws IndexException {
        boolean wasInterrupted = false;
        if (this.fExclusiveLock) {
            try {
                ArrayList<Chunk> dirtyChunks = new ArrayList<Chunk>();
                ChunkCache chunkCache = this.fCache;
                synchronized (chunkCache) {
                    int i = 1;
                    while (i < this.fChunksUsed) {
                        Chunk chunk = this.fChunks[i];
                        if (chunk != null) {
                            if (chunk.fCacheIndex < 0) {
                                if (chunk.fDirty) {
                                    dirtyChunks.add(chunk);
                                } else {
                                    chunk.fLocked = false;
                                    this.fChunks[i] = null;
                                }
                            } else if (chunk.fLocked) {
                                if (chunk.fDirty) {
                                    if (flush) {
                                        dirtyChunks.add(chunk);
                                    }
                                } else {
                                    chunk.fLocked = false;
                                }
                            } else assert (!chunk.fDirty);
                        }
                        ++i;
                    }
                }
                wasInterrupted = this.flushAndUnlockChunks(dirtyChunks, flush) || wasInterrupted;
            }
            finally {
                this.fExclusiveLock = false;
            }
        }
        return wasInterrupted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean flush() throws IndexException {
        boolean wasInterrupted = false;
        assert (this.fLocked);
        if (this.fExclusiveLock) {
            try {
                wasInterrupted = this.giveUpExclusiveLock(true) || wasInterrupted;
            }
            finally {
                this.setExclusiveLock();
            }
            return wasInterrupted;
        }
        ArrayList<Chunk> dirtyChunks = new ArrayList<Chunk>();
        ChunkCache chunkCache = this.fCache;
        synchronized (chunkCache) {
            int i = 1;
            while (i < this.fChunksUsed) {
                Chunk chunk = this.fChunks[i];
                if (chunk != null && chunk.fDirty) {
                    dirtyChunks.add(chunk);
                }
                ++i;
            }
        }
        return this.flushAndUnlockChunks(dirtyChunks, true) || wasInterrupted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean flushAndUnlockChunks(ArrayList<Chunk> dirtyChunks, boolean isComplete) throws IndexException {
        boolean wasInterrupted = false;
        assert (!Thread.holdsLock(this.fCache));
        Chunk chunk = this.fHeaderChunk;
        synchronized (chunk) {
            boolean haveDirtyChunks;
            boolean bl = haveDirtyChunks = !dirtyChunks.isEmpty();
            if (haveDirtyChunks || this.fHeaderChunk.fDirty) {
                boolean bl2 = wasInterrupted = this.markFileIncomplete() || wasInterrupted;
            }
            if (haveDirtyChunks) {
                for (Chunk chunk2 : dirtyChunks) {
                    if (!chunk2.fDirty) continue;
                    boolean bl3 = wasInterrupted = chunk2.flush() || wasInterrupted;
                }
                ChunkCache chunkCache = this.fCache;
                synchronized (chunkCache) {
                    for (Chunk chunk3 : dirtyChunks) {
                        chunk3.fLocked = false;
                        if (chunk3.fCacheIndex >= 0) continue;
                        this.fChunks[chunk3.fSequenceNumber] = null;
                    }
                }
            }
            if (isComplete && (this.fHeaderChunk.fDirty || this.fIsMarkedIncomplete)) {
                this.fHeaderChunk.putInt(0L, this.fVersion);
                wasInterrupted = this.fHeaderChunk.flush() || wasInterrupted;
                this.fIsMarkedIncomplete = false;
            }
        }
        return wasInterrupted;
    }

    private boolean markFileIncomplete() throws IndexException {
        boolean wasInterrupted = false;
        if (!this.fIsMarkedIncomplete) {
            this.fIsMarkedIncomplete = true;
            try {
                ByteBuffer buf = ByteBuffer.wrap(new byte[4]);
                wasInterrupted = this.performUninterruptableWrite(() -> {
                    int n = this.fFile.getChannel().write(buf, 0L);
                });
            }
            catch (IOException e) {
                throw new IndexException(new DBStatus(e));
            }
        }
        return wasInterrupted;
    }

    public void resetCacheCounters() {
        this.cacheMisses = 0L;
        this.cacheHits = 0L;
    }

    public long getCacheHits() {
        return this.cacheHits;
    }

    public long getCacheMisses() {
        return this.cacheMisses;
    }

    public long getSizeBytes() throws IOException {
        return this.fFile.length();
    }

    public int getChunkCount() {
        return this.fChunksUsed;
    }

    public static void putRecPtr(long value, byte[] buffer, int idx) {
        int denseValue = value == 0L ? 0 : Chunk.compressFreeRecPtr(value - 2L);
        Chunk.putInt(denseValue, buffer, idx);
    }

    public static long getRecPtr(byte[] buffer, int idx) {
        int value = Chunk.getInt(buffer, idx);
        long address = Chunk.expandToFreeRecPtr(value);
        return address != 0L ? address + 2L : address;
    }

    public MemoryStats getMemoryStats() {
        return this.memoryUsage;
    }

    public static long getBytesThatFitInChunks(int numChunks) {
        return 4096 * numChunks - LargeBlock.HEADER_SIZE - LargeBlock.FOOTER_SIZE - 2;
    }

    public static int getChunksNeededForBytes(long datasize) {
        return Database.divideRoundingUp(datasize + 2L + (long)LargeBlock.HEADER_SIZE + (long)LargeBlock.FOOTER_SIZE, 4096);
    }

    private static interface IORunnable {
        public void run() throws IOException;
    }
}

