/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.refresh;

import org.eclipse.core.internal.refresh.MonitorJob;
import org.eclipse.core.internal.refresh.MonitorManager;
import org.eclipse.core.internal.refresh.RefreshJob;
import org.eclipse.core.internal.resources.IManager;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.refresh.IRefreshMonitor;
import org.eclipse.core.resources.refresh.IRefreshResult;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.SubMonitor;

public class RefreshManager
implements IRefreshResult,
IManager,
Preferences.IPropertyChangeListener {
    public static final String DEBUG_PREFIX = "Auto-refresh: ";
    MonitorManager monitors;
    private RefreshJob refreshJob;
    private IWorkspace workspace;

    public RefreshManager(IWorkspace workspace) {
        this.workspace = workspace;
    }

    protected void manageAutoRefresh(boolean enabled, IProgressMonitor progressMonitor) {
        if (this.refreshJob == null) {
            return;
        }
        SubMonitor subMonitor = SubMonitor.convert(progressMonitor, 1);
        if (enabled) {
            this.refreshJob.start();
            this.monitors.start(subMonitor.split(1));
        } else {
            this.refreshJob.stop();
            this.monitors.stop();
        }
    }

    @Override
    public void monitorFailed(IRefreshMonitor monitor, IResource resource) {
        this.monitors.monitorFailed(monitor, resource);
    }

    @Override
    @Deprecated
    public void propertyChange(Preferences.PropertyChangeEvent event) {
        String property = event.getProperty();
        if ("refresh.enabled".equals(property)) {
            Preferences preferences = ResourcesPlugin.getPlugin().getPluginPreferences();
            boolean autoRefresh = preferences.getBoolean("refresh.enabled");
            String jobName = autoRefresh ? Messages.refresh_installMonitorsOnWorkspace : Messages.refresh_uninstallMonitorsOnWorkspace;
            MonitorJob.createSystem(jobName, ResourcesPlugin.getWorkspace().getRoot(), monitor -> this.manageAutoRefresh(autoRefresh, monitor)).schedule();
        }
    }

    @Override
    public void refresh(IResource resource) {
        if (this.refreshJob != null) {
            this.refreshJob.refresh(resource);
        }
    }

    @Override
    public void shutdown(IProgressMonitor monitor) {
        ResourcesPlugin.getPlugin().getPluginPreferences().removePropertyChangeListener(this);
        if (this.monitors != null) {
            this.monitors.stop();
            this.monitors = null;
        }
        if (this.refreshJob != null) {
            this.refreshJob.stop();
            this.refreshJob = null;
        }
    }

    @Override
    public void startup(IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert(monitor, 1);
        Preferences preferences = ResourcesPlugin.getPlugin().getPluginPreferences();
        preferences.addPropertyChangeListener(this);
        this.refreshJob = new RefreshJob();
        this.monitors = new MonitorManager(this.workspace, this);
        boolean autoRefresh = preferences.getBoolean("refresh.enabled");
        if (autoRefresh) {
            this.manageAutoRefresh(autoRefresh, subMonitor.split(1));
        }
    }
}

