/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.bcel;

import java.util.Iterator;
import java.util.List;
import org.aspectj.apache.bcel.classfile.annotation.AnnotationGen;
import org.aspectj.apache.bcel.classfile.annotation.ElementNameValuePairGen;
import org.aspectj.apache.bcel.classfile.annotation.EnumElementValueGen;
import org.aspectj.apache.bcel.generic.Instruction;
import org.aspectj.apache.bcel.generic.InstructionFactory;
import org.aspectj.apache.bcel.generic.InstructionList;
import org.aspectj.apache.bcel.generic.Type;
import org.aspectj.weaver.AnnotationX;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.Shadow;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.bcel.AnnotationAccessVar;
import org.aspectj.weaver.bcel.BcelVar;

public class AnnotationAccessFieldVar
extends BcelVar {
    AnnotationAccessVar aav;
    ResolvedType f;

    public AnnotationAccessFieldVar(AnnotationAccessVar aav, ResolvedType field) {
        super(field, 0);
        this.aav = aav;
        this.f = field;
    }

    void appendConvertableArrayLoad(InstructionList il, InstructionFactory fact, int index, ResolvedType convertTo) {
        super.appendConvertableArrayLoad(il, fact, index, convertTo);
    }

    void appendConvertableArrayStore(InstructionList il, InstructionFactory fact, int index, BcelVar storee) {
        super.appendConvertableArrayStore(il, fact, index, storee);
    }

    public void appendLoad(InstructionList il, InstructionFactory fact) {
        super.appendLoad(il, fact);
    }

    public void appendLoadAndConvert(InstructionList il, InstructionFactory fact, ResolvedType toType) {
        System.err.println("Loading " + toType);
        if (this.aav.getKind() == Shadow.MethodExecution) {
            Member holder = this.aav.getMember();
            AnnotationX[] annos = holder.getAnnotations();
            for (int i = 0; i < annos.length; ++i) {
                ResolvedType rt;
                AnnotationGen ag = annos[i].getBcelAnnotation();
                List vals = ag.getValues();
                boolean doneAndDusted = false;
                Iterator iterator = vals.iterator();
                while (iterator.hasNext()) {
                    ElementNameValuePairGen object = (ElementNameValuePairGen)iterator.next();
                    String name = object.getNameString();
                    EnumElementValueGen v = (EnumElementValueGen)object.getValue();
                    String s = v.getEnumTypeString();
                    rt = toType.getWorld().resolve(UnresolvedType.forSignature(s));
                    if (!rt.equals(toType)) continue;
                    il.append(fact.createGetStatic(rt.getName(), v.getEnumValueString(), Type.getType(rt.getSignature())));
                    doneAndDusted = true;
                }
                if (doneAndDusted) continue;
                ResolvedMember[] annotationFields = toType.getWorld().resolve(UnresolvedType.forSignature(ag.getTypeSignature())).getDeclaredMethods();
                for (int ii = 0; ii < annotationFields.length; ++ii) {
                    if (!annotationFields[ii].getType().equals(this.f)) continue;
                    String dvalue = annotationFields[ii].getAnnotationDefaultValue();
                    String typename = dvalue.substring(0, dvalue.lastIndexOf(59) + 1);
                    String field = dvalue.substring(dvalue.lastIndexOf(59) + 1);
                    rt = toType.getWorld().resolve(UnresolvedType.forSignature(typename));
                    il.append(fact.createGetStatic(rt.getName(), field, Type.getType(rt.getSignature())));
                }
            }
        } else {
            throw new RuntimeException("You, sir, are having a laugh");
        }
    }

    public void appendStore(InstructionList il, InstructionFactory fact) {
        super.appendStore(il, fact);
    }

    InstructionList createConvertableArrayLoad(InstructionFactory fact, int index, ResolvedType convertTo) {
        return super.createConvertableArrayLoad(fact, index, convertTo);
    }

    InstructionList createConvertableArrayStore(InstructionFactory fact, int index, BcelVar storee) {
        return super.createConvertableArrayStore(fact, index, storee);
    }

    public InstructionList createCopyFrom(InstructionFactory fact, int oldSlot) {
        return super.createCopyFrom(fact, oldSlot);
    }

    public Instruction createLoad(InstructionFactory fact) {
        return null;
    }

    public Instruction createStore(InstructionFactory fact) {
        return super.createStore(fact);
    }

    public int getPositionInAroundState() {
        return super.getPositionInAroundState();
    }

    public int getSlot() {
        return super.getSlot();
    }

    public void insertLoad(InstructionList il, InstructionFactory fact) {
        super.insertLoad(il, fact);
    }

    public void setPositionInAroundState(int positionInAroundState) {
        super.setPositionInAroundState(positionInAroundState);
    }

    public String toString() {
        return super.toString();
    }
}

