/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.classfile;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.StringTokenizer;
import org.aspectj.apache.bcel.classfile.Attribute;
import org.aspectj.apache.bcel.classfile.AttributeUtils;
import org.aspectj.apache.bcel.classfile.ClassVisitor;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.classfile.Field;
import org.aspectj.apache.bcel.classfile.InnerClass;
import org.aspectj.apache.bcel.classfile.InnerClasses;
import org.aspectj.apache.bcel.classfile.Method;
import org.aspectj.apache.bcel.classfile.Modifiers;
import org.aspectj.apache.bcel.classfile.Node;
import org.aspectj.apache.bcel.classfile.Signature;
import org.aspectj.apache.bcel.classfile.SourceFile;
import org.aspectj.apache.bcel.classfile.Utility;
import org.aspectj.apache.bcel.classfile.annotation.AnnotationGen;
import org.aspectj.apache.bcel.classfile.annotation.RuntimeAnnos;
import org.aspectj.apache.bcel.generic.Type;
import org.aspectj.apache.bcel.util.Repository;
import org.aspectj.apache.bcel.util.SyntheticRepository;

public class JavaClass
extends Modifiers
implements Cloneable,
Node {
    private static final String[] NoInterfaceNames = new String[0];
    private static final Field[] NoFields = new Field[0];
    private static final Method[] NoMethod = new Method[0];
    private static final int[] NoInterfaceIndices = new int[0];
    private static final Attribute[] NoAttributes = new Attribute[0];
    private String fileName;
    private String packageName;
    private String sourcefileName;
    private int classnameIdx;
    private int superclassnameIdx;
    private String classname;
    private String superclassname;
    private int major;
    private int minor;
    private ConstantPool cpool;
    private int[] interfaces;
    private String[] interfacenames;
    private Field[] fields;
    private Method[] methods;
    private Attribute[] attributes;
    private AnnotationGen[] annotations;
    private boolean isGeneric = false;
    private boolean isAnonymous = false;
    private boolean isNested = false;
    private boolean computedNestedTypeStatus = false;
    private boolean annotationsOutOfDate = true;
    private String signatureAttributeString = null;
    private Signature signatureAttribute = null;
    private boolean searchedForSignatureAttribute = false;
    private transient Repository repository = null;

    public JavaClass(int n, int n2, String string, int n3, int n4, int n5, ConstantPool constantPool, int[] nArray, Field[] fieldArray, Method[] methodArray, Attribute[] attributeArray) {
        if (nArray == null) {
            nArray = NoInterfaceIndices;
        }
        this.classnameIdx = n;
        this.superclassnameIdx = n2;
        this.fileName = string;
        this.major = n3;
        this.minor = n4;
        this.modifiers = n5;
        this.cpool = constantPool;
        this.interfaces = nArray;
        this.fields = fieldArray == null ? NoFields : fieldArray;
        this.methods = methodArray == null ? NoMethod : methodArray;
        this.attributes = attributeArray == null ? NoAttributes : attributeArray;
        this.annotationsOutOfDate = true;
        SourceFile sourceFile = AttributeUtils.getSourceFileAttribute(attributeArray);
        this.sourcefileName = sourceFile == null ? "<Unknown>" : sourceFile.getSourceFileName();
        this.classname = constantPool.getConstantString(n, (byte)7);
        this.classname = Utility.compactClassName(this.classname, false);
        int n6 = this.classname.lastIndexOf(46);
        this.packageName = n6 < 0 ? "" : this.classname.substring(0, n6);
        if (n2 > 0) {
            this.superclassname = constantPool.getConstantString(n2, (byte)7);
            this.superclassname = Utility.compactClassName(this.superclassname, false);
        } else {
            this.superclassname = "java.lang.Object";
        }
        if (nArray.length == 0) {
            this.interfacenames = NoInterfaceNames;
        } else {
            this.interfacenames = new String[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                String string2 = constantPool.getConstantString(nArray[i], (byte)7);
                this.interfacenames[i] = Utility.compactClassName(string2, false);
            }
        }
    }

    @Override
    public void accept(ClassVisitor classVisitor) {
        classVisitor.visitJavaClass(this);
    }

    public void dump(File file) throws IOException {
        String string = file.getParent();
        if (string != null) {
            File file2 = new File(string);
            file2.mkdirs();
        }
        this.dump(new DataOutputStream(new FileOutputStream(file)));
    }

    public void dump(String string) throws IOException {
        this.dump(new File(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            this.dump(dataOutputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            try {
                dataOutputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    public void dump(OutputStream outputStream) throws IOException {
        this.dump(new DataOutputStream(outputStream));
    }

    public void dump(DataOutputStream dataOutputStream) throws IOException {
        int n;
        dataOutputStream.writeInt(-889275714);
        dataOutputStream.writeShort(this.minor);
        dataOutputStream.writeShort(this.major);
        this.cpool.dump(dataOutputStream);
        dataOutputStream.writeShort(this.modifiers);
        dataOutputStream.writeShort(this.classnameIdx);
        dataOutputStream.writeShort(this.superclassnameIdx);
        dataOutputStream.writeShort(this.interfaces.length);
        for (n = 0; n < this.interfaces.length; ++n) {
            dataOutputStream.writeShort(this.interfaces[n]);
        }
        dataOutputStream.writeShort(this.fields.length);
        for (n = 0; n < this.fields.length; ++n) {
            this.fields[n].dump(dataOutputStream);
        }
        dataOutputStream.writeShort(this.methods.length);
        for (n = 0; n < this.methods.length; ++n) {
            this.methods[n].dump(dataOutputStream);
        }
        AttributeUtils.writeAttributes(this.attributes, dataOutputStream);
        dataOutputStream.close();
    }

    public Attribute[] getAttributes() {
        return this.attributes;
    }

    public AnnotationGen[] getAnnotations() {
        if (this.annotationsOutOfDate) {
            ArrayList<AnnotationGen> arrayList = new ArrayList<AnnotationGen>();
            for (int i = 0; i < this.attributes.length; ++i) {
                Attribute attribute = this.attributes[i];
                if (!(attribute instanceof RuntimeAnnos)) continue;
                RuntimeAnnos runtimeAnnos = (RuntimeAnnos)attribute;
                arrayList.addAll(runtimeAnnos.getAnnotations());
            }
            this.annotations = arrayList.toArray(new AnnotationGen[0]);
            this.annotationsOutOfDate = false;
        }
        return this.annotations;
    }

    public String getClassName() {
        return this.classname;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public int getClassNameIndex() {
        return this.classnameIdx;
    }

    public ConstantPool getConstantPool() {
        return this.cpool;
    }

    public Field[] getFields() {
        return this.fields;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String[] getInterfaceNames() {
        return this.interfacenames;
    }

    public int[] getInterfaceIndices() {
        return this.interfaces;
    }

    public int getMajor() {
        return this.major;
    }

    public Method[] getMethods() {
        return this.methods;
    }

    public Method getMethod(java.lang.reflect.Method method) {
        for (int i = 0; i < this.methods.length; ++i) {
            Method method2 = this.methods[i];
            if (!method.getName().equals(method2.getName()) || method.getModifiers() != method2.getModifiers() || !Type.getSignature(method).equals(method2.getSignature())) continue;
            return method2;
        }
        return null;
    }

    public Method getMethod(Constructor<?> constructor) {
        for (int i = 0; i < this.methods.length; ++i) {
            Method method = this.methods[i];
            if (!method.getName().equals("<init>") || constructor.getModifiers() != method.getModifiers() || !Type.getSignature(constructor).equals(method.getSignature())) continue;
            return method;
        }
        return null;
    }

    public Field getField(java.lang.reflect.Field field) {
        String string = field.getName();
        for (Field field2 : this.fields) {
            if (!field2.getName().equals(string)) continue;
            return field2;
        }
        return null;
    }

    public int getMinor() {
        return this.minor;
    }

    public String getSourceFileName() {
        return this.sourcefileName;
    }

    public String getSuperclassName() {
        return this.superclassname;
    }

    public int getSuperclassNameIndex() {
        return this.superclassnameIdx;
    }

    public void setAttributes(Attribute[] attributeArray) {
        this.attributes = attributeArray;
        this.annotationsOutOfDate = true;
    }

    public void setClassName(String string) {
        this.classname = string;
    }

    public void setClassNameIndex(int n) {
        this.classnameIdx = n;
    }

    public void setConstantPool(ConstantPool constantPool) {
        this.cpool = constantPool;
    }

    public void setFields(Field[] fieldArray) {
        this.fields = fieldArray;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public void setInterfaceNames(String[] stringArray) {
        this.interfacenames = stringArray;
    }

    public void setInterfaces(int[] nArray) {
        this.interfaces = nArray;
    }

    public void setMajor(int n) {
        this.major = n;
    }

    public void setMethods(Method[] methodArray) {
        this.methods = methodArray;
    }

    public void setMinor(int n) {
        this.minor = n;
    }

    public void setSourceFileName(String string) {
        this.sourcefileName = string;
    }

    public void setSuperclassName(String string) {
        this.superclassname = string;
    }

    public void setSuperclassNameIndex(int n) {
        this.superclassnameIdx = n;
    }

    public String toString() {
        int n;
        String string = Utility.accessToString(this.modifiers, true);
        string = string.equals("") ? "" : string + " ";
        StringBuffer stringBuffer = new StringBuffer(string + Utility.classOrInterface(this.modifiers) + " " + this.classname + " extends " + Utility.compactClassName(this.superclassname, false) + '\n');
        int n2 = this.interfaces.length;
        if (n2 > 0) {
            stringBuffer.append("implements\t\t");
            for (n = 0; n < n2; ++n) {
                stringBuffer.append(this.interfacenames[n]);
                if (n >= n2 - 1) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append('\n');
        }
        stringBuffer.append("filename\t\t" + this.fileName + '\n');
        stringBuffer.append("compiled from\t\t" + this.sourcefileName + '\n');
        stringBuffer.append("compiler version\t" + this.major + "." + this.minor + '\n');
        stringBuffer.append("access flags\t\t" + this.modifiers + '\n');
        stringBuffer.append("constant pool\t\t" + this.cpool.getLength() + " entries\n");
        stringBuffer.append("ACC_SUPER flag\t\t" + this.isSuper() + "\n");
        if (this.attributes.length > 0) {
            stringBuffer.append("\nAttribute(s):\n");
            for (n = 0; n < this.attributes.length; ++n) {
                stringBuffer.append(JavaClass.indent(this.attributes[n]));
            }
        }
        if (this.annotations != null && this.annotations.length > 0) {
            stringBuffer.append("\nAnnotation(s):\n");
            for (n = 0; n < this.annotations.length; ++n) {
                stringBuffer.append(JavaClass.indent(this.annotations[n]));
            }
        }
        if (this.fields.length > 0) {
            stringBuffer.append("\n" + this.fields.length + " fields:\n");
            for (n = 0; n < this.fields.length; ++n) {
                stringBuffer.append("\t" + this.fields[n] + '\n');
            }
        }
        if (this.methods.length > 0) {
            stringBuffer.append("\n" + this.methods.length + " methods:\n");
            for (n = 0; n < this.methods.length; ++n) {
                stringBuffer.append("\t" + this.methods[n] + '\n');
            }
        }
        return stringBuffer.toString();
    }

    private static final String indent(Object object) {
        StringTokenizer stringTokenizer = new StringTokenizer(object.toString(), "\n");
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append("\t" + stringTokenizer.nextToken() + "\n");
        }
        return stringBuffer.toString();
    }

    public final boolean isSuper() {
        return (this.modifiers & 0x20) != 0;
    }

    public final boolean isClass() {
        return (this.modifiers & 0x200) == 0;
    }

    public final boolean isAnonymous() {
        this.computeNestedTypeStatus();
        return this.isAnonymous;
    }

    public final boolean isNested() {
        this.computeNestedTypeStatus();
        return this.isNested;
    }

    private final void computeNestedTypeStatus() {
        if (this.computedNestedTypeStatus) {
            return;
        }
        for (int i = 0; i < this.attributes.length; ++i) {
            if (!(this.attributes[i] instanceof InnerClasses)) continue;
            InnerClass[] innerClassArray = ((InnerClasses)this.attributes[i]).getInnerClasses();
            for (int j = 0; j < innerClassArray.length; ++j) {
                boolean bl = false;
                String string = this.cpool.getConstantString(innerClassArray[j].getInnerClassIndex(), (byte)7);
                if ((string = Utility.compactClassName(string)).equals(this.getClassName())) {
                    bl = true;
                }
                if (!bl) continue;
                this.isNested = true;
                if (innerClassArray[j].getInnerNameIndex() != 0) continue;
                this.isAnonymous = true;
            }
        }
        this.computedNestedTypeStatus = true;
    }

    public final boolean isAnnotation() {
        return (this.modifiers & 0x2000) != 0;
    }

    public final boolean isEnum() {
        return (this.modifiers & 0x4000) != 0;
    }

    public Repository getRepository() {
        if (this.repository == null) {
            this.repository = SyntheticRepository.getInstance();
        }
        return this.repository;
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    public final boolean instanceOf(JavaClass javaClass) {
        if (this.equals(javaClass)) {
            return true;
        }
        JavaClass[] javaClassArray = this.getSuperClasses();
        for (int i = 0; i < javaClassArray.length; ++i) {
            if (!javaClassArray[i].equals(javaClass)) continue;
            return true;
        }
        if (javaClass.isInterface()) {
            return this.implementationOf(javaClass);
        }
        return false;
    }

    public boolean implementationOf(JavaClass javaClass) {
        if (!javaClass.isInterface()) {
            throw new IllegalArgumentException(javaClass.getClassName() + " is no interface");
        }
        if (this.equals(javaClass)) {
            return true;
        }
        Collection<JavaClass> collection = this.getAllInterfaces();
        for (JavaClass javaClass2 : collection) {
            if (!javaClass2.equals(javaClass)) continue;
            return true;
        }
        return false;
    }

    public JavaClass getSuperClass() {
        if ("java.lang.Object".equals(this.getClassName())) {
            return null;
        }
        try {
            return this.getRepository().loadClass(this.getSuperclassName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println(classNotFoundException);
            return null;
        }
    }

    public JavaClass[] getSuperClasses() {
        JavaClass javaClass = this;
        ArrayList<JavaClass> arrayList = new ArrayList<JavaClass>();
        for (javaClass = javaClass.getSuperClass(); javaClass != null; javaClass = javaClass.getSuperClass()) {
            arrayList.add(javaClass);
        }
        return arrayList.toArray(new JavaClass[arrayList.size()]);
    }

    public JavaClass[] getInterfaces() {
        String[] stringArray = this.getInterfaceNames();
        JavaClass[] javaClassArray = new JavaClass[stringArray.length];
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                javaClassArray[i] = this.getRepository().loadClass(stringArray[i]);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println(classNotFoundException);
            return null;
        }
        return javaClassArray;
    }

    public Collection<JavaClass> getAllInterfaces() {
        LinkedList<JavaClass> linkedList = new LinkedList<JavaClass>();
        ArrayList<JavaClass> arrayList = new ArrayList<JavaClass>();
        linkedList.add(this);
        while (!linkedList.isEmpty()) {
            JavaClass javaClass = (JavaClass)linkedList.remove();
            JavaClass javaClass2 = javaClass.getSuperClass();
            JavaClass[] javaClassArray = javaClass.getInterfaces();
            if (javaClass.isInterface()) {
                arrayList.add(javaClass);
            } else if (javaClass2 != null) {
                linkedList.add(javaClass2);
            }
            for (int i = 0; i < javaClassArray.length; ++i) {
                linkedList.add(javaClassArray[i]);
            }
        }
        return arrayList;
    }

    public final String getGenericSignature() {
        this.loadGenericSignatureInfoIfNecessary();
        return this.signatureAttributeString;
    }

    public boolean isGeneric() {
        this.loadGenericSignatureInfoIfNecessary();
        return this.isGeneric;
    }

    private void loadGenericSignatureInfoIfNecessary() {
        if (!this.searchedForSignatureAttribute) {
            this.signatureAttribute = AttributeUtils.getSignatureAttribute(this.attributes);
            this.signatureAttributeString = this.signatureAttribute == null ? null : this.signatureAttribute.getSignature();
            this.isGeneric = this.signatureAttribute != null && this.signatureAttributeString.charAt(0) == '<';
            this.searchedForSignatureAttribute = true;
        }
    }

    public final Signature getSignatureAttribute() {
        this.loadGenericSignatureInfoIfNecessary();
        return this.signatureAttribute;
    }
}

