/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.generic;

import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.apache.bcel.generic.InstructionHandle;
import org.aspectj.apache.bcel.generic.InstructionSelect;
import org.aspectj.apache.bcel.util.ByteSequence;

public class LOOKUPSWITCH
extends InstructionSelect {
    public LOOKUPSWITCH(int[] nArray, InstructionHandle[] instructionHandleArray, InstructionHandle instructionHandle) {
        super((short)171, nArray, instructionHandleArray, instructionHandle);
        this.length = (short)(9 + this.matchLength * 8);
        this.fixedLength = this.length;
    }

    @Override
    public void dump(DataOutputStream dataOutputStream) throws IOException {
        super.dump(dataOutputStream);
        dataOutputStream.writeInt(this.matchLength);
        for (int i = 0; i < this.matchLength; ++i) {
            dataOutputStream.writeInt(this.match[i]);
            this.indices[i] = this.getTargetOffset(this.targets[i]);
            dataOutputStream.writeInt(this.indices[i]);
        }
    }

    public LOOKUPSWITCH(ByteSequence byteSequence) throws IOException {
        super((short)171, byteSequence);
        this.matchLength = byteSequence.readInt();
        this.fixedLength = (short)(9 + this.matchLength * 8);
        this.length = (short)(this.fixedLength + this.padding);
        this.match = new int[this.matchLength];
        this.indices = new int[this.matchLength];
        this.targets = new InstructionHandle[this.matchLength];
        for (int i = 0; i < this.matchLength; ++i) {
            this.match[i] = byteSequence.readInt();
            this.indices[i] = byteSequence.readInt();
        }
    }
}

