/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.assertions.generator.description;

import org.assertj.assertions.generator.description.TypeDescription;

public abstract class DataDescription {
    private final String name;
    protected final TypeDescription typeDescription;

    public DataDescription(String name, TypeDescription typeDescription) {
        this.name = name;
        this.typeDescription = typeDescription;
    }

    public String getName() {
        return this.name;
    }

    public String getTypeName() {
        return this.typeDescription.getSimpleNameWithOuterClass();
    }

    public boolean isIterableType() {
        return this.typeDescription.isIterable();
    }

    public boolean isArrayType() {
        return this.typeDescription.isArray();
    }

    public boolean isPrimitiveType() {
        return this.typeDescription.isPrimitive();
    }

    public boolean isRealNumberType() {
        return this.typeDescription.isRealNumber();
    }

    public boolean isBooleanType() {
        return this.typeDescription.isBoolean();
    }

    public String getElementTypeName(String packageName) {
        return this.typeDescription.getElementTypeName() == null ? null : this.typeDescription.getElementTypeName().getFullyQualifiedTypeNameIfNeeded(packageName);
    }

    public String getFullyQualifiedTypeNameIfNeeded(String packageName) {
        return this.typeDescription.getFullyQualifiedTypeNameIfNeeded(packageName);
    }
}

