/*
 * Created on Sep 21, 2010
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the
 * License. You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an "AS IS"
 * BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 * 
 * Copyright @2010-2011 the original author or authors.
 */
package org.assertj.core.error;

import org.assertj.core.description.Description;

/**
 * Creates an error message that indicates an assertion that verifies that an object is not {@code null} failed.
 * 
 * @author Alex Ruiz
 */
public class ShouldNotBeNull implements ErrorMessageFactory {

  private static final ShouldNotBeNull INSTANCE = new ShouldNotBeNull();

  /**
   * Returns the singleton instance of this class.
   * @return the singleton instance of this class.
   */
  public static ErrorMessageFactory shouldNotBeNull() {
    return INSTANCE;
  }

  private ShouldNotBeNull() {}

  /** {@inheritDoc} */
  public String create(Description d) {
    return MessageFormatter.instance().format(d, "\nExpecting actual not to be null");
  }
}
