/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import org.assertj.core.api.AssertionInfo;
import org.assertj.core.data.Offset;
import org.assertj.core.data.Percentage;
import org.assertj.core.error.ShouldBeEqualWithinOffset;
import org.assertj.core.error.ShouldBeEqualWithinPercentage;
import org.assertj.core.internal.CommonValidations;
import org.assertj.core.internal.ComparisonStrategy;
import org.assertj.core.internal.Numbers;
import org.assertj.core.util.VisibleForTesting;

public class Longs
extends Numbers<Long> {
    private static final Longs INSTANCE = new Longs();

    public static Longs instance() {
        return INSTANCE;
    }

    @Override
    protected Long zero() {
        return 0L;
    }

    @VisibleForTesting
    Longs() {
    }

    public Longs(ComparisonStrategy comparisonStrategy) {
        super(comparisonStrategy);
    }

    @Override
    public void assertIsCloseTo(AssertionInfo info, Long actual, Long expected, Offset<Long> offset) {
        Longs.assertNotNull(info, actual);
        CommonValidations.checkOffsetIsNotNull(offset);
        CommonValidations.checkNumberIsNotNull(expected);
        long absDiff = Math.abs(expected - actual);
        if (absDiff > (Long)offset.value) {
            throw this.failures.failure(info, ShouldBeEqualWithinOffset.shouldBeEqual(actual, expected, offset, absDiff));
        }
    }

    @Override
    public void assertIsCloseToPercentage(AssertionInfo info, Long actual, Long other, Percentage percentage) {
        Longs.assertNotNull(info, actual);
        CommonValidations.checkPercentageIsNotNull(percentage);
        CommonValidations.checkNumberIsNotNull(other);
        Offset<Double> calculatedOffset = Offset.offset(percentage.value * (double)other.longValue() / 100.0);
        Long absDiff = Math.abs(other - actual);
        if ((double)absDiff.longValue() > (Double)calculatedOffset.value) {
            throw this.failures.failure(info, ShouldBeEqualWithinPercentage.shouldBeEqualWithinPercentage(actual, other, percentage, absDiff));
        }
    }
}

