/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.lang.reflect.Constructor;
import java.util.List;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractListAssert;

public class ClassBasedNavigableListAssert<SELF extends ClassBasedNavigableListAssert<SELF, ACTUAL, ELEMENT, ELEMENT_ASSERT>, ACTUAL extends List<? extends ELEMENT>, ELEMENT, ELEMENT_ASSERT extends AbstractAssert<ELEMENT_ASSERT, ELEMENT>>
extends AbstractListAssert<SELF, ACTUAL, ELEMENT, ELEMENT_ASSERT> {
    private Class<ELEMENT_ASSERT> assertClass;

    public ClassBasedNavigableListAssert(ACTUAL actual, Class<ELEMENT_ASSERT> assertClass) {
        super(actual, ClassBasedNavigableListAssert.class);
        this.assertClass = assertClass;
    }

    @Override
    public ELEMENT_ASSERT toAssert(ELEMENT value, String description) {
        return this.buildAssert(value, description, value.getClass());
    }

    private <V> ELEMENT_ASSERT buildAssert(V value, String description, Class<?> clazz) {
        try {
            Constructor<?>[] declaredConstructors = this.assertClass.getDeclaredConstructors();
            for (int i = 0; i < declaredConstructors.length; ++i) {
                Constructor<?> constructor = declaredConstructors[i];
                if (constructor.getParameterTypes().length != 1 || !constructor.getParameterTypes()[0].isAssignableFrom(clazz)) continue;
                AbstractAssert newAssert = (AbstractAssert)constructor.newInstance(value);
                return (ELEMENT_ASSERT)newAssert.as(description, new Object[0]);
            }
            throw new RuntimeException("Failed to find a constructor matching " + value + " class to build the expected Assert class");
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to build an assert object with " + value + ": " + e.getMessage(), e);
        }
    }
}

