/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.Optional;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.error.OptionalShouldBeEmpty;
import org.assertj.core.error.OptionalShouldBePresent;
import org.assertj.core.error.OptionalShouldContain;

public abstract class AbstractOptionalAssert<S extends AbstractOptionalAssert<S, T>, T>
extends AbstractAssert<S, Optional<T>> {
    protected AbstractOptionalAssert(Optional<T> actual, Class<?> selfType) {
        super(actual, selfType);
    }

    public S isPresent() {
        this.isNotNull();
        if (!((Optional)this.actual).isPresent()) {
            throw this.failure(OptionalShouldBePresent.shouldBePresent());
        }
        return (S)((AbstractOptionalAssert)this.myself);
    }

    public S isEmpty() {
        this.isNotNull();
        if (((Optional)this.actual).isPresent()) {
            throw this.failure(OptionalShouldBeEmpty.shouldBeEmpty((Optional)this.actual));
        }
        return (S)((AbstractOptionalAssert)this.myself);
    }

    public S contains(T expectedValue) {
        this.isNotNull();
        if (expectedValue == null) {
            throw new IllegalArgumentException("The expected value should not be <null>.");
        }
        if (!((Optional)this.actual).isPresent()) {
            throw this.failure(OptionalShouldContain.shouldContain(expectedValue));
        }
        if (!((Optional)this.actual).get().equals(expectedValue)) {
            throw this.failure(OptionalShouldContain.shouldContain((Optional)this.actual, expectedValue));
        }
        return (S)((AbstractOptionalAssert)this.myself);
    }
}

