/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.extractor;

import java.util.Map;
import org.assertj.core.api.iterable.Extractor;
import org.assertj.core.internal.PropertySupport;
import org.assertj.core.util.introspection.FieldSupport;
import org.assertj.core.util.introspection.IntrospectionError;

class ByNameSingleExtractor<T>
implements Extractor<T, Object> {
    private final String propertyOrFieldName;

    ByNameSingleExtractor(String propertyOrFieldName) {
        this.propertyOrFieldName = propertyOrFieldName;
    }

    @Override
    public Object extract(T input) {
        if (this.propertyOrFieldName == null) {
            throw new IllegalArgumentException("The name of the field/property to read should not be null");
        }
        if (this.propertyOrFieldName.length() == 0) {
            throw new IllegalArgumentException("The name of the field/property to read should not be empty");
        }
        if (input == null) {
            throw new IllegalArgumentException("The object to extract field/property from should not be null");
        }
        if (input instanceof Map) {
            Map map = (Map)input;
            return map.get(this.propertyOrFieldName);
        }
        try {
            return PropertySupport.instance().propertyValueOf(this.propertyOrFieldName, Object.class, input);
        }
        catch (IntrospectionError fieldIntrospectionError) {
            try {
                return FieldSupport.extraction().fieldValue(this.propertyOrFieldName, Object.class, input);
            }
            catch (IntrospectionError propertyIntrospectionError) {
                String message = String.format("%nCan't find any field or property with name '%s'.%nError when introspecting fields was :%n- %s %nError when introspecting properties was :%n- %s", this.propertyOrFieldName, fieldIntrospectionError.getMessage(), propertyIntrospectionError.getMessage());
                throw new IntrospectionError(message);
            }
        }
    }
}

