/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.configuration;

import java.util.List;
import org.assertj.core.configuration.Configuration;
import org.assertj.core.configuration.Services;
import org.assertj.core.presentation.CompositeRepresentation;
import org.assertj.core.presentation.Representation;

public final class ConfigurationProvider {
    public static final ConfigurationProvider CONFIGURATION_PROVIDER = new ConfigurationProvider();
    private final Configuration configuration = Services.get(Configuration.class, Configuration.DEFAULT_CONFIGURATION);
    private CompositeRepresentation compositeRepresentation;

    private ConfigurationProvider() {
        if (this.configuration != Configuration.DEFAULT_CONFIGURATION) {
            this.configuration.applyAndDisplay();
        }
        List<Representation> representations = Services.getAll(Representation.class);
        this.compositeRepresentation = new CompositeRepresentation(representations);
        if (!this.configuration.hasCustomRepresentation()) {
            if (representations.size() == 1) {
                System.out.println(String.format("AssertJ has found one registered representation: %s, AssertJ will use it first and then fall back to standard representation if it returned a null representation of the value to display.", representations.get(0)));
            } else if (representations.size() > 1) {
                System.out.println(String.format("AssertJ has found %s registered representations, AssertJ will use them first and then fall back to standard representation if they returned a null representation of the value to display, the order (by highest priority first) of use will be: %s", representations.size(), this.compositeRepresentation.getAllRepresentationsOrderedByPriority()));
            }
        } else if (!representations.isEmpty()) {
            System.out.println(String.format("AssertJ has found these representations %s in the classpath but they won't be used as the loaded configuration has specified a custom representation which takes precedence over representations loaded with the java ServiceLoader: %s", representations, this.representation()));
        }
    }

    public Representation representation() {
        return this.configuration.hasCustomRepresentation() ? this.configuration.representation() : this.compositeRepresentation;
    }

    public Configuration configuration() {
        return this.configuration;
    }

    public static void loadRegisteredConfiguration() {
    }
}

