/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.junit.ant;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.util.DOMElementWriter;
import org.apache.tools.ant.util.FileUtils;
import org.assertj.swing.junit.ant.StandardOutputStreams;
import org.assertj.swing.junit.xml.XmlNode;

class XmlOutputWriter {
    private static final String CHARSET = "UTF8";
    private static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>";
    private static final String INDENT = "  ";
    private final StandardOutputStreams outputStreams;

    XmlOutputWriter() {
        this(new StandardOutputStreams());
    }

    XmlOutputWriter(StandardOutputStreams outputStreams) {
        this.outputStreams = outputStreams;
    }

    void write(XmlNode xml, OutputStream out) {
        this.write(xml, out, new DOMElementWriter());
    }

    void write(XmlNode xml, OutputStream out, DOMElementWriter xmlWriter) {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter(out, CHARSET));
            writer.write(XML_HEADER);
            writer.write(System.lineSeparator());
            xmlWriter.write(xml.target(), (Writer)writer, 0, INDENT);
            ((Writer)writer).flush();
        }
        catch (IOException ex) {
            throw new BuildException("Unable to write log file", (Throwable)ex);
        }
        finally {
            if (!this.outputStreams.isStandardOutOrErr(out)) {
                FileUtils.close((Writer)writer);
            }
        }
    }
}

