/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.junit.runner;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.assertj.core.util.Files;
import org.assertj.core.util.Strings;

class FolderCreator {
    FolderCreator() {
    }

    File createFolder(File parent, String name, boolean deleteIfExists) {
        try {
            String canonicalPath = parent.getCanonicalPath();
            File imageFolder = new File(Strings.concat((Object[])new Object[]{canonicalPath, File.separator, name}));
            if (deleteIfExists) {
                Files.delete((File)imageFolder);
            }
            imageFolder.mkdir();
            return imageFolder;
        }
        catch (Exception e) {
            String message = Strings.concat((Object[])new Object[]{"Unable to create directory ", Strings.quote((String)name)});
            if (e instanceof IOException) {
                throw new UncheckedIOException(message, (IOException)e);
            }
            throw new RuntimeException(message, e);
        }
    }
}

