/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.vavr.api;

import io.vavr.CheckedFunction0;
import io.vavr.control.Try;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import net.bytebuddy.dynamic.loading.ClassInjector;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;

class ClassLoadingStrategyFactory {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    private static final Method PRIVATE_LOOKUP_IN = (Method)Try.of((CheckedFunction0 & Serializable)() -> MethodHandles.class.getMethod("privateLookupIn", Class.class, MethodHandles.Lookup.class)).getOrElse((Object)null);

    ClassLoadingStrategyFactory() {
    }

    static ClassLoadingStrategy<ClassLoader> classLoadingStrategy(Class<?> assertClass) {
        if (ClassInjector.UsingReflection.isAvailable()) {
            return ClassLoadingStrategy.Default.INJECTION;
        }
        if (ClassInjector.UsingLookup.isAvailable() && PRIVATE_LOOKUP_IN != null) {
            try {
                return ClassLoadingStrategy.UsingLookup.of((Object)PRIVATE_LOOKUP_IN.invoke(null, assertClass, LOOKUP));
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not access package of " + assertClass, e);
            }
        }
        throw new IllegalStateException("No code generation strategy available");
    }
}

