/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.vavr.api;

import io.vavr.control.Validation;
import org.assertj.core.error.BasicErrorMessageFactory;

class ValidationShouldContainInstanceOf
extends BasicErrorMessageFactory {
    private static final String EXPECTING_TO_CONTAIN_BUT_IS_INVALID = "%nExpecting:%n  <%s>%nto contain a valid:%n  <%s>%nbut was invalid.";
    private static final String EXPECTING_TO_CONTAIN_BUT_IS_VALID = "%nExpecting:%n  <%s>%nto contain an invalid:%n  <%s>%nbut was valid.";
    private static final String EXPECTING_TO_CONTAIN_DIFFERENT_INSTANCE = "%nExpecting:%n <%s>%nto contain a value that is an instance of:%n <%s>%nbut did contain an instance of:%n <%s>";

    private ValidationShouldContainInstanceOf(String message) {
        super(message, new Object[0]);
    }

    static ValidationShouldContainInstanceOf shouldContainValidInstanceOf(Object value, Class<?> expectedClazz) {
        Validation validation = (Validation)value;
        if (validation.isValid()) {
            return new ValidationShouldContainInstanceOf(String.format(EXPECTING_TO_CONTAIN_DIFFERENT_INSTANCE, validation.getClass().getSimpleName(), expectedClazz.getName(), validation.get().getClass().getName()));
        }
        return new ValidationShouldContainInstanceOf(String.format(EXPECTING_TO_CONTAIN_BUT_IS_INVALID, validation.getClass().getSimpleName(), expectedClazz.getName()));
    }

    static ValidationShouldContainInstanceOf shouldContainInvalidInstanceOf(Object value, Class<?> expectedClazz) {
        Validation validation = (Validation)value;
        if (validation.isInvalid()) {
            return new ValidationShouldContainInstanceOf(String.format(EXPECTING_TO_CONTAIN_DIFFERENT_INSTANCE, validation.getClass().getSimpleName(), expectedClazz.getName(), validation.getError().getClass().getName()));
        }
        return new ValidationShouldContainInstanceOf(String.format(EXPECTING_TO_CONTAIN_BUT_IS_VALID, validation.getClass().getSimpleName(), expectedClazz.getName()));
    }
}

