/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.atmosphere.cpr.SessionTimeoutRestorer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SessionTimeoutSupport {
    private static final String KEY = "atmosphere.session.timeout.restorer";
    private static final Logger logger = LoggerFactory.getLogger(SessionTimeoutSupport.class);

    public static void setupTimeout(HttpSession session) {
        if (session == null) {
            return;
        }
        try {
            SessionTimeoutRestorer restorer = SessionTimeoutSupport.getOrCreate(session);
            restorer.setup(session);
        }
        catch (Exception e) {
            logger.trace("", (Throwable)e);
        }
    }

    public static void restoreTimeout(HttpSession session) {
        if (session == null) {
            return;
        }
        try {
            SessionTimeoutRestorer restorer = SessionTimeoutSupport.get(session);
            if (restorer != null) {
                restorer.restore(session);
            }
        }
        catch (Exception e) {
            logger.trace("", (Throwable)e);
        }
    }

    public static void restoreTimeout(HttpServletRequest request) {
        SessionTimeoutSupport.restoreTimeout(request.getSession(false));
    }

    private static SessionTimeoutRestorer get(HttpSession s) {
        return (SessionTimeoutRestorer)s.getAttribute(KEY);
    }

    private static SessionTimeoutRestorer getOrCreate(HttpSession s) {
        SessionTimeoutRestorer restorer = (SessionTimeoutRestorer)s.getAttribute(KEY);
        if (restorer == null) {
            restorer = new SessionTimeoutRestorer(s.getMaxInactiveInterval());
            s.setAttribute(KEY, (Object)restorer);
        }
        return restorer;
    }
}

