/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.cluster.socket;

import com.avaje.ebeaninternal.server.cluster.socket.SocketClusterBroadcast;
import com.avaje.ebeaninternal.server.cluster.socket.SocketConnection;
import java.io.IOException;
import java.net.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RequestProcessor
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(RequestProcessor.class);
    private final Socket clientSocket;
    private final SocketClusterBroadcast owner;

    public RequestProcessor(SocketClusterBroadcast owner, Socket clientSocket) {
        this.clientSocket = clientSocket;
        this.owner = owner;
    }

    @Override
    public void run() {
        try {
            SocketConnection sc = new SocketConnection(this.clientSocket);
            while (!this.owner.process(sc)) {
            }
            sc.disconnect();
        }
        catch (IOException e) {
            logger.error(null, (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            logger.error(null, (Throwable)e);
        }
    }
}

