/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.core;

import com.avaje.ebean.ValuePair;
import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.deploy.BeanProperty;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyAssocOne;
import com.avaje.ebeaninternal.util.ValueUtil;
import java.util.LinkedHashMap;
import java.util.Map;

public class DiffHelp {
    public Map<String, ValuePair> diff(Object a, Object b, BeanDescriptor<?> desc) {
        boolean oldValues = false;
        if (b == null && a instanceof EntityBean) {
            EntityBean eb = (EntityBean)a;
            b = eb._ebean_getIntercept().getOldValues();
            oldValues = true;
        }
        LinkedHashMap<String, ValuePair> map = new LinkedHashMap<String, ValuePair>();
        if (b == null) {
            return map;
        }
        BeanProperty[] base = desc.propertiesBaseScalar();
        for (int i = 0; i < base.length; ++i) {
            Object bval;
            Object aval = base[i].getValue(a);
            if (ValueUtil.areEqual(aval, bval = base[i].getValue(b))) continue;
            map.put(base[i].getName(), new ValuePair(aval, bval));
        }
        this.diffAssocOne(a, b, desc, map);
        this.diffEmbedded(a, b, desc, map, oldValues);
        return map;
    }

    private void diffEmbedded(Object a, Object b, BeanDescriptor<?> desc, Map<String, ValuePair> map, boolean oldValues) {
        BeanPropertyAssocOne<?>[] emb = desc.propertiesEmbedded();
        for (int i = 0; i < emb.length; ++i) {
            Object aval = emb[i].getValue(a);
            Object bval = emb[i].getValue(b);
            if (oldValues && (bval = ((EntityBean)bval)._ebean_getIntercept().getOldValues()) == null || this.isBothNull(aval, bval)) continue;
            if (this.isDiffNull(aval, bval)) {
                map.put(emb[i].getName(), new ValuePair(aval, bval));
                continue;
            }
            BeanProperty[] props = emb[i].getProperties();
            for (int j = 0; j < props.length; ++j) {
                Object bEmbPropVal;
                Object aEmbPropVal = props[j].getValue(aval);
                if (ValueUtil.areEqual(aEmbPropVal, bEmbPropVal = props[j].getValue(bval))) continue;
                map.put(emb[i].getName(), new ValuePair(aval, bval));
            }
        }
    }

    private void diffAssocOne(Object a, Object b, BeanDescriptor<?> desc, Map<String, ValuePair> map) {
        BeanPropertyAssocOne<?>[] ones = desc.propertiesOne();
        for (int i = 0; i < ones.length; ++i) {
            Object bOneId;
            Object bval;
            Object aval = ones[i].getValue(a);
            if (this.isBothNull(aval, bval = ones[i].getValue(b))) continue;
            if (this.isDiffNull(aval, bval)) {
                map.put(ones[i].getName(), new ValuePair(aval, bval));
                continue;
            }
            BeanDescriptor oneDesc = ones[i].getTargetDescriptor();
            Object aOneId = oneDesc.getId(aval);
            if (ValueUtil.areEqual(aOneId, bOneId = oneDesc.getId(bval))) continue;
            map.put(ones[i].getName(), new ValuePair(aval, bval));
        }
    }

    private boolean isBothNull(Object aval, Object bval) {
        return aval == null && bval == null;
    }

    private boolean isDiffNull(Object aval, Object bval) {
        if (aval == null) {
            return bval != null;
        }
        return bval == null;
    }
}

