/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.deploy;

import com.avaje.ebean.text.StringFormatter;
import com.avaje.ebean.text.StringParser;
import com.avaje.ebeaninternal.server.deploy.BeanProperty;
import com.avaje.ebeaninternal.server.el.ElPropertyValue;

public final class BeanFkeyProperty
implements ElPropertyValue {
    private final String placeHolder;
    private final String prefix;
    private final String name;
    private final String dbColumn;
    private int deployOrder;

    public BeanFkeyProperty(String prefix, String name, String dbColumn, int deployOrder) {
        this.prefix = prefix;
        this.name = name;
        this.dbColumn = dbColumn;
        this.deployOrder = deployOrder;
        this.placeHolder = this.calcPlaceHolder(prefix, dbColumn);
    }

    @Override
    public int getDeployOrder() {
        return this.deployOrder;
    }

    private String calcPlaceHolder(String prefix, String dbColumn) {
        if (prefix != null) {
            return "${" + prefix + "}" + dbColumn;
        }
        return "${}" + dbColumn;
    }

    public BeanFkeyProperty create(String expression) {
        int len = expression.length() - this.name.length() - 1;
        String prefix = expression.substring(0, len);
        return new BeanFkeyProperty(prefix, this.name, this.dbColumn, this.deployOrder);
    }

    @Override
    public boolean isDbEncrypted() {
        return false;
    }

    @Override
    public boolean isLocalEncrypted() {
        return false;
    }

    public boolean isDeployOnly() {
        return true;
    }

    @Override
    public boolean containsMany() {
        return false;
    }

    @Override
    public boolean containsManySince(String sinceProperty) {
        return this.containsMany();
    }

    @Override
    public String getDbColumn() {
        return this.dbColumn;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getElName() {
        return this.name;
    }

    @Override
    public Object[] getAssocOneIdValues(Object value) {
        return null;
    }

    @Override
    public String getAssocOneIdExpr(String prefix, String operator) {
        return null;
    }

    @Override
    public String getAssocIdInExpr(String prefix) {
        return null;
    }

    @Override
    public String getAssocIdInValueExpr(int size) {
        return null;
    }

    @Override
    public boolean isAssocId() {
        return false;
    }

    @Override
    public boolean isAssocProperty() {
        return false;
    }

    @Override
    public String getElPlaceholder(boolean encrypted) {
        return this.placeHolder;
    }

    @Override
    public String getElPrefix() {
        return this.prefix;
    }

    @Override
    public boolean isDateTimeCapable() {
        return false;
    }

    @Override
    public int getJdbcType() {
        return 0;
    }

    @Override
    public Object parseDateTime(long systemTimeMillis) {
        throw new RuntimeException("ElPropertyDeploy only - not implemented");
    }

    @Override
    public StringFormatter getStringFormatter() {
        throw new RuntimeException("ElPropertyDeploy only - not implemented");
    }

    @Override
    public StringParser getStringParser() {
        throw new RuntimeException("ElPropertyDeploy only - not implemented");
    }

    @Override
    public void elSetReference(Object bean) {
        throw new RuntimeException("ElPropertyDeploy only - not implemented");
    }

    @Override
    public Object elConvertType(Object value) {
        throw new RuntimeException("ElPropertyDeploy only - not implemented");
    }

    @Override
    public void elSetValue(Object bean, Object value, boolean populate, boolean reference) {
        throw new RuntimeException("ElPropertyDeploy only - not implemented");
    }

    @Override
    public Object elGetValue(Object bean) {
        throw new RuntimeException("ElPropertyDeploy only - not implemented");
    }

    @Override
    public Object elGetReference(Object bean) {
        throw new RuntimeException("ElPropertyDeploy only - not implemented");
    }

    @Override
    public BeanProperty getBeanProperty() {
        throw new RuntimeException("ElPropertyDeploy only - not implemented");
    }

    public String getDeployProperty() {
        throw new RuntimeException("ElPropertyDeploy only - not implemented");
    }
}

