/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.query;

import com.avaje.ebean.BackgroundExecutor;
import com.avaje.ebean.QueryIterator;
import com.avaje.ebean.bean.BeanCollection;
import com.avaje.ebean.bean.BeanCollectionTouched;
import com.avaje.ebean.bean.ObjectGraphNode;
import com.avaje.ebean.config.dbplatform.DatabasePlatform;
import com.avaje.ebeaninternal.api.BeanIdList;
import com.avaje.ebeaninternal.api.SpiQuery;
import com.avaje.ebeaninternal.api.SpiTransaction;
import com.avaje.ebeaninternal.server.core.OrmQueryRequest;
import com.avaje.ebeaninternal.server.persist.Binder;
import com.avaje.ebeaninternal.server.query.BackgroundFetch;
import com.avaje.ebeaninternal.server.query.CQuery;
import com.avaje.ebeaninternal.server.query.CQueryBuilder;
import com.avaje.ebeaninternal.server.query.CQueryFetchIds;
import com.avaje.ebeaninternal.server.query.CQueryRowCount;
import com.avaje.ebeaninternal.server.transaction.TransactionManager;
import java.sql.SQLException;
import java.util.concurrent.FutureTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CQueryEngine {
    private static final Logger logger = LoggerFactory.getLogger(CQueryEngine.class);
    private final CQueryBuilder queryBuilder;
    private final BackgroundExecutor backgroundExecutor;
    private final int defaultSecondaryQueryBatchSize = 100;

    public CQueryEngine(DatabasePlatform dbPlatform, Binder binder, BackgroundExecutor backgroundExecutor) {
        this.backgroundExecutor = backgroundExecutor;
        this.queryBuilder = new CQueryBuilder(backgroundExecutor, dbPlatform, binder);
    }

    public <T> CQuery<T> buildQuery(OrmQueryRequest<T> request) {
        return this.queryBuilder.buildQuery(request);
    }

    public <T> BeanIdList findIds(OrmQueryRequest<T> request) {
        CQueryFetchIds rcQuery = this.queryBuilder.buildFetchIdsQuery(request);
        try {
            BeanIdList list = rcQuery.findIds();
            if (request.isLogSql()) {
                String logSql = rcQuery.getGeneratedSql();
                if (TransactionManager.SQL_LOGGER.isTraceEnabled()) {
                    logSql = logSql + "; --bind(" + rcQuery.getBindLog() + ")";
                }
                request.logSql(logSql);
            }
            if (request.isLogSummary()) {
                request.getTransaction().logSummary(rcQuery.getSummary());
            }
            if (!list.isFetchingInBackground() && request.getQuery().isFutureFetch()) {
                logger.debug("Future findIds completed!");
                request.getTransaction().end();
            }
            return list;
        }
        catch (SQLException e) {
            throw CQuery.createPersistenceException(e, (SpiTransaction)request.getTransaction(), rcQuery.getBindLog(), rcQuery.getGeneratedSql());
        }
    }

    public <T> int findRowCount(OrmQueryRequest<T> request) {
        CQueryRowCount rcQuery = this.queryBuilder.buildRowCountQuery(request);
        try {
            int rowCount = rcQuery.findRowCount();
            if (request.isLogSql()) {
                String logSql = rcQuery.getGeneratedSql();
                if (TransactionManager.SQL_LOGGER.isTraceEnabled()) {
                    logSql = logSql + "; --bind(" + rcQuery.getBindLog() + ")";
                }
                request.logSql(logSql);
            }
            if (request.isLogSummary()) {
                request.getTransaction().logSummary(rcQuery.getSummary());
            }
            if (request.getQuery().isFutureFetch()) {
                logger.debug("Future findRowCount completed!");
                request.getTransaction().end();
            }
            return rowCount;
        }
        catch (SQLException e) {
            throw CQuery.createPersistenceException(e, (SpiTransaction)request.getTransaction(), rcQuery.getBindLog(), rcQuery.getGeneratedSql());
        }
    }

    public <T> QueryIterator<T> findIterate(OrmQueryRequest<T> request) {
        CQuery<T> cquery = this.queryBuilder.buildQuery(request);
        request.setCancelableQuery(cquery);
        try {
            if (!cquery.prepareBindExecuteQuery()) {
                logger.trace("Future fetch already cancelled");
                return null;
            }
            if (request.isLogSql()) {
                this.logSql(cquery);
            }
            int iterateBufferSize = request.getSecondaryQueriesMinBatchSize(100);
            QueryIterator<T> readIterate = cquery.readIterate(iterateBufferSize, request);
            if (request.isLogSummary()) {
                this.logFindManySummary(cquery);
            }
            return readIterate;
        }
        catch (SQLException e) {
            throw cquery.createPersistenceException(e);
        }
    }

    public <T> BeanCollection<T> findMany(OrmQueryRequest<T> request) {
        boolean useBackgroundToContinueFetch = false;
        CQuery<T> cquery = this.queryBuilder.buildQuery(request);
        request.setCancelableQuery(cquery);
        try {
            if (!cquery.prepareBindExecuteQuery()) {
                logger.trace("Future fetch already cancelled");
                BeanCollection<T> beanCollection = null;
                return beanCollection;
            }
            if (request.isLogSql()) {
                this.logSql(cquery);
            }
            BeanCollection<T> beanCollection = cquery.readCollection();
            BeanCollectionTouched collectionTouched = request.getQuery().getBeanCollectionTouched();
            if (collectionTouched != null) {
                beanCollection.setBeanCollectionTouched(collectionTouched);
            }
            if (cquery.useBackgroundToContinueFetch()) {
                request.setBackgroundFetching();
                useBackgroundToContinueFetch = true;
                BackgroundFetch fetch = new BackgroundFetch(cquery);
                FutureTask<Integer> future = new FutureTask<Integer>(fetch);
                beanCollection.setBackgroundFetch(future);
                this.backgroundExecutor.execute(future);
            }
            if (request.isLogSummary()) {
                this.logFindManySummary(cquery);
            }
            request.executeSecondaryQueries(100);
            BeanCollection<T> beanCollection2 = beanCollection;
            return beanCollection2;
        }
        catch (SQLException e) {
            throw cquery.createPersistenceException(e);
        }
        finally {
            if (!useBackgroundToContinueFetch) {
                if (cquery != null) {
                    cquery.close();
                }
                if (request.getQuery().isFutureFetch()) {
                    logger.debug("Future fetch completed!");
                    request.getTransaction().end();
                }
            }
        }
    }

    public <T> T find(OrmQueryRequest<T> request) {
        T bean = null;
        CQuery<T> cquery = this.queryBuilder.buildQuery(request);
        try {
            cquery.prepareBindExecuteQuery();
            if (request.isLogSql()) {
                this.logSql(cquery);
            }
            if (cquery.readBean()) {
                bean = cquery.getLoadedBean();
            }
            if (request.isLogSummary()) {
                this.logFindBeanSummary(cquery);
            }
            request.executeSecondaryQueries(100);
            T t = bean;
            return t;
        }
        catch (SQLException e) {
            throw cquery.createPersistenceException(e);
        }
        finally {
            cquery.close();
        }
    }

    private void logSql(CQuery<?> query) {
        String sql = query.getGeneratedSql();
        if (TransactionManager.SQL_LOGGER.isTraceEnabled()) {
            sql = sql + "; --bind(" + query.getBindLog() + ")";
        }
        query.getTransaction().logSql(sql);
    }

    private void logFindBeanSummary(CQuery<?> q) {
        SpiQuery<?> query = q.getQueryRequest().getQuery();
        String loadMode = query.getLoadMode();
        String loadDesc = query.getLoadDescription();
        String lazyLoadProp = query.getLazyLoadProperty();
        ObjectGraphNode node = query.getParentNode();
        String originKey = node == null || node.getOriginQueryPoint() == null ? null : node.getOriginQueryPoint().getKey();
        StringBuilder msg = new StringBuilder(200);
        msg.append("FindBean ");
        if (loadMode != null) {
            msg.append("mode[").append(loadMode).append("] ");
        }
        msg.append("type[").append(q.getBeanName()).append("] ");
        if (query.isAutofetchTuned()) {
            msg.append("tuned[true] ");
        }
        if (originKey != null) {
            msg.append("origin[").append(originKey).append("] ");
        }
        if (lazyLoadProp != null) {
            msg.append("lazyLoadProp[").append(lazyLoadProp).append("] ");
        }
        if (loadDesc != null) {
            msg.append("load[").append(loadDesc).append("] ");
        }
        msg.append("exeMicros[").append(q.getQueryExecutionTimeMicros());
        msg.append("] rows[").append(q.getLoadedRowDetail());
        msg.append("] bind[").append(q.getBindLog()).append("]");
        q.getTransaction().logSummary(msg.toString());
    }

    private void logFindManySummary(CQuery<?> q) {
        SpiQuery<?> query = q.getQueryRequest().getQuery();
        String loadMode = query.getLoadMode();
        String loadDesc = query.getLoadDescription();
        String lazyLoadProp = query.getLazyLoadProperty();
        ObjectGraphNode node = query.getParentNode();
        String originKey = node == null || node.getOriginQueryPoint() == null ? null : node.getOriginQueryPoint().getKey();
        StringBuilder msg = new StringBuilder(200);
        msg.append("FindMany ");
        if (loadMode != null) {
            msg.append("mode[").append(loadMode).append("] ");
        }
        msg.append("type[").append(q.getBeanName()).append("] ");
        if (query.isAutofetchTuned()) {
            msg.append("tuned[true] ");
        }
        if (originKey != null) {
            msg.append("origin[").append(originKey).append("] ");
        }
        if (lazyLoadProp != null) {
            msg.append("lazyLoadProp[").append(lazyLoadProp).append("] ");
        }
        if (loadDesc != null) {
            msg.append("load[").append(loadDesc).append("] ");
        }
        msg.append("exeMicros[").append(q.getQueryExecutionTimeMicros());
        msg.append("] rows[").append(q.getLoadedRowDetail());
        msg.append("] name[").append(q.getName());
        msg.append("] predicates[").append(q.getLogWhereSql());
        msg.append("] bind[").append(q.getBindLog()).append("]");
        q.getTransaction().logSummary(msg.toString());
    }
}

