/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.transaction;

import com.avaje.ebean.BackgroundExecutor;
import com.avaje.ebean.config.GlobalProperties;
import com.avaje.ebean.config.ServerConfig;
import com.avaje.ebean.event.TransactionEventListener;
import com.avaje.ebeaninternal.api.SpiTransaction;
import com.avaje.ebeaninternal.api.TransactionEvent;
import com.avaje.ebeaninternal.api.TransactionEventTable;
import com.avaje.ebeaninternal.server.cluster.ClusterManager;
import com.avaje.ebeaninternal.server.core.BootupClasses;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptorManager;
import com.avaje.ebeaninternal.server.lib.sql.DataSourcePool;
import com.avaje.ebeaninternal.server.transaction.BeanPersistIds;
import com.avaje.ebeaninternal.server.transaction.BulkEventListenerMap;
import com.avaje.ebeaninternal.server.transaction.ExternalJdbcTransaction;
import com.avaje.ebeaninternal.server.transaction.JdbcTransaction;
import com.avaje.ebeaninternal.server.transaction.PostCommitProcessing;
import com.avaje.ebeaninternal.server.transaction.RemoteTransactionEvent;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.persistence.PersistenceException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionManager {
    private static final Logger logger = LoggerFactory.getLogger(TransactionManager.class);
    public static final Logger SQL_LOGGER = LoggerFactory.getLogger((String)"org.avaje.ebean.SQL");
    public static final Logger SUM_LOGGER = LoggerFactory.getLogger((String)"org.avaje.ebean.SUM");
    public static final Logger TXN_LOGGER = LoggerFactory.getLogger((String)"org.avaje.ebean.TXN");
    private final BeanDescriptorManager beanDescriptorManager;
    private final String prefix;
    private final String externalTransPrefix;
    private final DataSource dataSource;
    private final OnQueryOnly onQueryOnly;
    private final boolean defaultBatchMode;
    private final BackgroundExecutor backgroundExecutor;
    private final ClusterManager clusterManager;
    private final String serverName;
    private AtomicLong transactionCounter = new AtomicLong(1000L);
    private int clusterDebugLevel;
    private final BulkEventListenerMap bulkEventListenerMap;
    private TransactionEventListener[] transactionEventListeners;

    public TransactionManager(ClusterManager clusterManager, BackgroundExecutor backgroundExecutor, ServerConfig config, BeanDescriptorManager descMgr, BootupClasses bootupClasses) {
        this.beanDescriptorManager = descMgr;
        this.clusterManager = clusterManager;
        this.serverName = config.getName();
        this.backgroundExecutor = backgroundExecutor;
        this.dataSource = config.getDataSource();
        this.bulkEventListenerMap = new BulkEventListenerMap(config.getBulkTableEventListeners());
        List<TransactionEventListener> transactionEventListeners = bootupClasses.getTransactionEventListeners();
        this.transactionEventListeners = transactionEventListeners.toArray(new TransactionEventListener[transactionEventListeners.size()]);
        this.clusterDebugLevel = GlobalProperties.getInt("ebean.cluster.debuglevel", 0);
        this.defaultBatchMode = config.isPersistBatching();
        this.prefix = GlobalProperties.get("transaction.prefix", "");
        this.externalTransPrefix = GlobalProperties.get("transaction.prefix", "e");
        String value = GlobalProperties.get("transaction.onqueryonly", "ROLLBACK").toUpperCase().trim();
        this.onQueryOnly = this.getOnQueryOnly(value, this.dataSource);
        this.initialiseHeartbeat();
    }

    private void initialiseHeartbeat() {
        if (this.dataSource instanceof DataSourcePool) {
            DataSourcePool ds = (DataSourcePool)this.dataSource;
            this.backgroundExecutor.executePeriodically(ds.getHeartbeatRunnable(), ds.getHeartbeatFreqSecs(), TimeUnit.SECONDS);
        }
    }

    public void shutdown(boolean shutdownDataSource, boolean deregisterDriver) {
        if (shutdownDataSource && this.dataSource instanceof DataSourcePool) {
            ((DataSourcePool)this.dataSource).shutdown(deregisterDriver);
        }
    }

    public BeanDescriptorManager getBeanDescriptorManager() {
        return this.beanDescriptorManager;
    }

    public BulkEventListenerMap getBulkEventListenerMap() {
        return this.bulkEventListenerMap;
    }

    private OnQueryOnly getOnQueryOnly(String onQueryOnly, DataSource ds) {
        if (onQueryOnly.equals("COMMIT")) {
            return OnQueryOnly.COMMIT;
        }
        if (onQueryOnly.startsWith("CLOSE")) {
            if (!this.isReadCommitedIsolation(ds)) {
                String m = "transaction.queryonlyclose is true but the transaction Isolation Level is not READ_COMMITTED";
                throw new PersistenceException(m);
            }
            return OnQueryOnly.CLOSE_ON_READCOMMITTED;
        }
        return OnQueryOnly.ROLLBACK;
    }

    private boolean isReadCommitedIsolation(DataSource ds) {
        Connection c = null;
        try {
            c = ds.getConnection();
            int isolationLevel = c.getTransactionIsolation();
            boolean bl = isolationLevel == 2;
            return bl;
        }
        catch (SQLException ex) {
            String m = "Errored trying to determine the default Isolation Level";
            throw new PersistenceException(m, (Throwable)ex);
        }
        finally {
            try {
                if (c != null) {
                    c.close();
                }
            }
            catch (SQLException ex) {
                logger.error("closing connection", (Throwable)ex);
            }
        }
    }

    public String getServerName() {
        return this.serverName;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public int getClusterDebugLevel() {
        return this.clusterDebugLevel;
    }

    public void setClusterDebugLevel(int clusterDebugLevel) {
        this.clusterDebugLevel = clusterDebugLevel;
    }

    public OnQueryOnly getOnQueryOnly() {
        return this.onQueryOnly;
    }

    public SpiTransaction wrapExternalConnection(Connection c) {
        return this.wrapExternalConnection(this.externalTransPrefix + c.hashCode(), c);
    }

    public SpiTransaction wrapExternalConnection(String id, Connection c) {
        ExternalJdbcTransaction t = new ExternalJdbcTransaction(id, true, c, this);
        if (this.defaultBatchMode) {
            t.setBatchMode(true);
        }
        return t;
    }

    public SpiTransaction createTransaction(boolean explicit, int isolationLevel) {
        Connection c = null;
        try {
            c = this.dataSource.getConnection();
            long id = this.transactionCounter.incrementAndGet();
            JdbcTransaction t = new JdbcTransaction(this.prefix + id, explicit, c, this);
            if (this.defaultBatchMode) {
                t.setBatchMode(true);
            }
            if (isolationLevel > -1) {
                c.setTransactionIsolation(isolationLevel);
            }
            if (explicit && TXN_LOGGER.isTraceEnabled()) {
                TXN_LOGGER.trace(t.getLogPrefix() + "Begin");
            }
            return t;
        }
        catch (SQLException ex) {
            try {
                if (c != null) {
                    c.close();
                }
            }
            catch (SQLException e) {
                logger.error("Error closing failed connection", (Throwable)e);
            }
            throw new PersistenceException((Throwable)ex);
        }
    }

    public SpiTransaction createQueryTransaction() {
        Connection c = null;
        try {
            c = this.dataSource.getConnection();
            long id = this.transactionCounter.incrementAndGet();
            JdbcTransaction t = new JdbcTransaction(this.prefix + id, false, c, this);
            if (this.defaultBatchMode) {
                t.setBatchMode(true);
            }
            return t;
        }
        catch (PersistenceException ex) {
            try {
                if (c != null) {
                    c.close();
                }
            }
            catch (SQLException e) {
                logger.error("Error closing failed connection", (Throwable)e);
            }
            throw ex;
        }
        catch (SQLException ex) {
            throw new PersistenceException((Throwable)ex);
        }
    }

    public void notifyOfRollback(SpiTransaction transaction, Throwable cause) {
        try {
            if (TXN_LOGGER.isInfoEnabled()) {
                String msg = transaction.getLogPrefix() + "Rollback";
                if (cause != null) {
                    msg = msg + " error: " + this.formatThrowable(cause);
                }
                TXN_LOGGER.info(msg);
            }
            for (TransactionEventListener listener : this.transactionEventListeners) {
                listener.postTransactionRollback(transaction, cause);
            }
        }
        catch (Exception ex) {
            logger.error("Error while notifying TransactionEventListener of rollback event", (Throwable)ex);
        }
    }

    public void notifyOfQueryOnly(boolean onCommit, SpiTransaction transaction, Throwable cause) {
        if (TXN_LOGGER.isTraceEnabled()) {
            TXN_LOGGER.trace(transaction.getLogPrefix() + "Commit - query only");
        }
    }

    private String formatThrowable(Throwable e) {
        if (e == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        this.formatThrowable(e, sb);
        return sb.toString();
    }

    private void formatThrowable(Throwable e, StringBuilder sb) {
        Throwable cause;
        sb.append(e.toString());
        StackTraceElement[] stackTrace = e.getStackTrace();
        if (stackTrace.length > 0) {
            sb.append(" stack0: ");
            sb.append(stackTrace[0]);
        }
        if ((cause = e.getCause()) != null) {
            sb.append(" cause: ");
            this.formatThrowable(cause, sb);
        }
    }

    public void notifyOfCommit(SpiTransaction transaction) {
        try {
            if (transaction.isExplicit()) {
                if (TXN_LOGGER.isInfoEnabled()) {
                    TXN_LOGGER.info(transaction.getLogPrefix() + "Commit");
                }
            } else if (TXN_LOGGER.isDebugEnabled()) {
                TXN_LOGGER.debug(transaction.getLogPrefix() + "Commit");
            }
            PostCommitProcessing postCommit = new PostCommitProcessing(this.clusterManager, this, transaction, transaction.getEvent());
            postCommit.notifyLocalCacheIndex();
            postCommit.notifyCluster();
            this.backgroundExecutor.execute(postCommit.notifyPersistListeners());
            for (TransactionEventListener listener : this.transactionEventListeners) {
                listener.postTransactionCommit(transaction);
            }
        }
        catch (Exception ex) {
            String m = "NotifyOfCommit failed. Cache/Lucene potentially not notified.";
            logger.error(m, (Throwable)ex);
        }
    }

    public void externalModification(TransactionEventTable tableEvents) {
        TransactionEvent event = new TransactionEvent();
        event.add(tableEvents);
        PostCommitProcessing postCommit = new PostCommitProcessing(this.clusterManager, this, null, event);
        postCommit.notifyLocalCacheIndex();
        this.backgroundExecutor.execute(postCommit.notifyPersistListeners());
    }

    public void remoteTransactionEvent(RemoteTransactionEvent remoteEvent) {
        List<BeanPersistIds> beanPersistList;
        List<TransactionEventTable.TableIUD> tableIUDList;
        if (this.clusterDebugLevel > 0 || logger.isDebugEnabled()) {
            logger.info("Cluster Received: " + remoteEvent.toString());
        }
        if ((tableIUDList = remoteEvent.getTableIUDList()) != null) {
            for (int i = 0; i < tableIUDList.size(); ++i) {
                TransactionEventTable.TableIUD tableIUD = tableIUDList.get(i);
                this.beanDescriptorManager.cacheNotify(tableIUD);
            }
        }
        if ((beanPersistList = remoteEvent.getBeanPersistList()) != null) {
            for (int i = 0; i < beanPersistList.size(); ++i) {
                BeanPersistIds beanPersist = beanPersistList.get(i);
                beanPersist.notifyCacheAndListener();
            }
        }
    }

    public static enum OnQueryOnly {
        ROLLBACK,
        CLOSE_ON_READCOMMITTED,
        COMMIT;

    }
}

