/*
 * Decompiled with CFR 0.152.
 */
package org.bigtesting.interpolatd.core;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bigtesting.interpolatd.core.Interpolating;
import org.bigtesting.interpolatd.core.Substitution;

public class EscapeHandler<T>
implements Interpolating<T> {
    private final String escape;
    private final Pattern pattern;

    public EscapeHandler(String escape) {
        this.escape = escape;
        this.pattern = Pattern.compile("(" + Pattern.quote(escape) + ")");
    }

    @Override
    public List<Substitution> interpolate(String toInterpolate, T arg) {
        ArrayList<Substitution> substitutions = new ArrayList<Substitution>();
        Matcher m = this.pattern.matcher(toInterpolate);
        while (m.find()) {
            substitutions.add(new Substitution(this.escape, "", m.start(), m.end(), true));
        }
        return substitutions;
    }
}

