/*
 * Decompiled with CFR 0.152.
 */
package org.bigtesting.interpolatd.core;

import java.util.ArrayList;
import java.util.List;
import org.bigtesting.interpolatd.EnclosureOpeningHandler;
import org.bigtesting.interpolatd.InterpolationHandler;
import org.bigtesting.interpolatd.PrefixHandler;
import org.bigtesting.interpolatd.core.EnclosureOpeningHandlerImpl;
import org.bigtesting.interpolatd.core.Interpolating;
import org.bigtesting.interpolatd.core.PrefixHandlerImpl;
import org.bigtesting.interpolatd.core.Substitution;

public class InterpolationHandlerImpl<T>
implements InterpolationHandler<T>,
Interpolating<T> {
    private PrefixHandlerImpl<T> prefixHandler;
    private EnclosureOpeningHandlerImpl<T> enclosureOpeningHandler;
    private final String characterClass;

    public InterpolationHandlerImpl() {
        this(null);
    }

    public InterpolationHandlerImpl(String characterClass) {
        this.characterClass = characterClass;
    }

    @Override
    public PrefixHandler<T> prefixedBy(String prefix) {
        PrefixHandlerImpl prefixHandler = new PrefixHandlerImpl(prefix, this.characterClass);
        this.prefixHandler = prefixHandler;
        return prefixHandler;
    }

    @Override
    public EnclosureOpeningHandler<T> enclosedBy(String opening) {
        EnclosureOpeningHandlerImpl enclosureOpeningHandler = new EnclosureOpeningHandlerImpl(opening, this.characterClass);
        this.enclosureOpeningHandler = enclosureOpeningHandler;
        return enclosureOpeningHandler;
    }

    @Override
    public List<Substitution> interpolate(String toInterpolate, T arg) {
        ArrayList<Substitution> substitutions = new ArrayList<Substitution>();
        if (this.prefixHandler != null) {
            substitutions.addAll(this.prefixHandler.interpolate(toInterpolate, arg));
        } else if (this.enclosureOpeningHandler != null) {
            substitutions.addAll(this.enclosureOpeningHandler.getEnclosureClosingHandler().interpolate(toInterpolate, arg));
        }
        return substitutions;
    }
}

