/*
 * Decompiled with CFR 0.152.
 */
package org.jose4j.json;

import java.io.IOException;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jose4j.lang.JoseException;
import org.json.simple.JSONValue;
import org.json.simple.parser.ContainerFactory;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class JsonUtil {
    private static final ContainerFactory CONTAINER_FACTORY = new ContainerFactory(){

        public List creatArrayContainer() {
            return new LinkedList();
        }

        public Map createObjectContainer() {
            return new LinkedHashMap();
        }
    };

    public static Map<String, Object> parseJson(String jsonString) throws JoseException {
        try {
            JSONParser parser = new JSONParser();
            return (Map)parser.parse(jsonString, CONTAINER_FACTORY);
        }
        catch (ParseException e) {
            throw new JoseException("Parsing error: " + (Object)((Object)e), e);
        }
    }

    public static String toJson(Map<String, ?> map) {
        return JSONValue.toJSONString(map);
    }

    public static void writeJson(Map<String, ?> map, Writer w) throws IOException {
        JSONValue.writeJSONString(map, (Writer)w);
    }
}

