/*
 * Decompiled with CFR 0.152.
 */
package org.jose4j.jwe;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jose4j.jwa.AlgorithmInfo;
import org.jose4j.jwe.CipherUtil;
import org.jose4j.jwe.ContentEncryptionKeyDescriptor;
import org.jose4j.jwe.ContentEncryptionKeys;
import org.jose4j.jwe.KeyManagementAlgorithm;
import org.jose4j.jwx.Headers;
import org.jose4j.lang.ByteUtil;
import org.jose4j.lang.JoseException;

public abstract class WrappingKeyManagementAlgorithm
extends AlgorithmInfo
implements KeyManagementAlgorithm {
    protected final Log log = LogFactory.getLog(this.getClass());
    private AlgorithmParameterSpec algorithmParameterSpec;

    public WrappingKeyManagementAlgorithm(String javaAlg, String alg) {
        this.setJavaAlgorithm(javaAlg);
        this.setAlgorithmIdentifier(alg);
    }

    public void setAlgorithmParameterSpec(AlgorithmParameterSpec algorithmParameterSpec) {
        this.algorithmParameterSpec = algorithmParameterSpec;
    }

    @Override
    public ContentEncryptionKeys manageForEncrypt(Key managementKey, ContentEncryptionKeyDescriptor cekDesc, Headers headers, byte[] cekOverride) throws JoseException {
        byte[] contentEncryptionKey = cekOverride == null ? ByteUtil.randomBytes(cekDesc.getContentEncryptionKeyByteLength()) : cekOverride;
        return this.manageForEnc(managementKey, cekDesc, contentEncryptionKey);
    }

    protected ContentEncryptionKeys manageForEnc(Key managementKey, ContentEncryptionKeyDescriptor cekDesc, byte[] contentEncryptionKey) throws JoseException {
        Cipher cipher = CipherUtil.getCipher(this.getJavaAlgorithm());
        try {
            this.initCipher(cipher, 3, managementKey);
            String contentEncryptionKeyAlgorithm = cekDesc.getContentEncryptionKeyAlgorithm();
            byte[] encryptedKey = cipher.wrap(new SecretKeySpec(contentEncryptionKey, contentEncryptionKeyAlgorithm));
            return new ContentEncryptionKeys(contentEncryptionKey, encryptedKey);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | IllegalBlockSizeException e) {
            throw new JoseException("Unable to encrypt the Content Encryption Key: " + e, e);
        }
    }

    void initCipher(Cipher cipher, int mode, Key key) throws InvalidAlgorithmParameterException, InvalidKeyException {
        if (this.algorithmParameterSpec == null) {
            cipher.init(mode, key);
        } else {
            cipher.init(mode, key, this.algorithmParameterSpec);
        }
    }

    @Override
    public Key manageForDecrypt(Key managementKey, byte[] encryptedKey, ContentEncryptionKeyDescriptor cekDesc, Headers headers) throws JoseException {
        Cipher cipher = CipherUtil.getCipher(this.getJavaAlgorithm());
        try {
            this.initCipher(cipher, 4, managementKey);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException e) {
            throw new JoseException("Unable to initialize cipher for key decryption", e);
        }
        String cekAlg = cekDesc.getContentEncryptionKeyAlgorithm();
        try {
            return cipher.unwrap(encryptedKey, cekAlg, 3);
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Key unwrap failed. Substituting a randomly generated CEK and proceeding.", (Throwable)e);
            }
            byte[] bytes = ByteUtil.randomBytes(cekDesc.getContentEncryptionKeyByteLength());
            return new SecretKeySpec(bytes, cekAlg);
        }
    }
}

