/*
 * Decompiled with CFR 0.152.
 */
package org.jose4j.jwk;

import java.math.BigInteger;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jose4j.json.JsonUtil;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.keys.BigEndianBigInteger;
import org.jose4j.keys.X509Util;
import org.jose4j.lang.JoseException;
import org.jose4j.lang.JsonHelp;

public abstract class PublicJsonWebKey
extends JsonWebKey {
    public static final String X509_CERTIFICATE_CHAIN_PARAMETER = "x5c";
    public static final String X509_THUMBPRINT_PARAMETER = "x5t";
    public static final String X509_URL_PARAMETER = "x5u";
    protected boolean writeOutPrivateKeyToJson;
    protected PrivateKey privateKey;
    private List<X509Certificate> certificateChain;

    protected PublicJsonWebKey(PublicKey publicKey) {
        super(publicKey);
    }

    protected PublicJsonWebKey(Map<String, Object> params) throws JoseException {
        super(params);
        if (params.containsKey(X509_CERTIFICATE_CHAIN_PARAMETER)) {
            List<String> x5cStrings = JsonHelp.getStringArray(params, X509_CERTIFICATE_CHAIN_PARAMETER);
            this.certificateChain = new ArrayList<X509Certificate>(x5cStrings.size());
            X509Util x509Util = new X509Util();
            for (String b64EncodedDer : x5cStrings) {
                X509Certificate x509Certificate = x509Util.fromBase64Der(b64EncodedDer);
                this.certificateChain.add(x509Certificate);
            }
        }
    }

    protected abstract void fillPublicTypeSpecificParams(Map<String, Object> var1);

    protected abstract void fillPrivateTypeSpecificParams(Map<String, Object> var1);

    @Override
    protected void fillTypeSpecificParams(Map<String, Object> params, JsonWebKey.OutputControlLevel outputLevel) {
        this.fillPublicTypeSpecificParams(params);
        if (this.certificateChain != null) {
            X509Util x509Util = new X509Util();
            ArrayList<String> x5cStrings = new ArrayList<String>(this.certificateChain.size());
            for (X509Certificate cert : this.certificateChain) {
                String b64EncodedDer = x509Util.toBase64Der(cert);
                x5cStrings.add(b64EncodedDer);
            }
            params.put(X509_CERTIFICATE_CHAIN_PARAMETER, x5cStrings);
        }
        if (this.writeOutPrivateKeyToJson || outputLevel == JsonWebKey.OutputControlLevel.INCLUDE_PRIVATE) {
            this.fillPrivateTypeSpecificParams(params);
        }
    }

    @Override
    public PublicKey getPublicKey() {
        return (PublicKey)this.key;
    }

    public void setWriteOutPrivateKeyToJson(boolean writeOutPrivateKeyToJson) {
        this.writeOutPrivateKeyToJson = writeOutPrivateKeyToJson;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    public List<X509Certificate> getCertificateChain() {
        return this.certificateChain;
    }

    public X509Certificate getLeafCertificate() {
        return this.certificateChain != null && !this.certificateChain.isEmpty() ? this.certificateChain.get(0) : null;
    }

    public void setCertificateChain(List<X509Certificate> certificateChain) {
        this.checkForBareKeyCertMismatch();
        this.certificateChain = certificateChain;
    }

    void checkForBareKeyCertMismatch() {
        boolean certAndBareKeyMismatch;
        X509Certificate leafCertificate = this.getLeafCertificate();
        boolean bl = certAndBareKeyMismatch = leafCertificate != null && !leafCertificate.getPublicKey().equals(this.getPublicKey());
        if (certAndBareKeyMismatch) {
            throw new IllegalArgumentException("The key in the first certificate MUST match the bare public key represented by other members of the JWK. Public key = " + this.getPublicKey() + " cert = " + leafCertificate);
        }
    }

    public void setCertificateChain(X509Certificate ... certificates) {
        this.setCertificateChain(Arrays.asList(certificates));
    }

    BigInteger getBigIntFromBase64UrlEncodedParam(Map<String, Object> params, String parameterName) {
        String base64UrlValue = JsonHelp.getString(params, parameterName);
        return BigEndianBigInteger.fromBase64Url(base64UrlValue);
    }

    void putBigIntAsBase64UrlEncodedParam(Map<String, Object> params, String parameterName, BigInteger value) {
        String base64UrlValue = BigEndianBigInteger.toBase64Url(value);
        params.put(parameterName, base64UrlValue);
    }

    void putBigIntAsBase64UrlEncodedParam(Map<String, Object> params, String parameterName, BigInteger value, int minLength) {
        String base64UrlValue = BigEndianBigInteger.toBase64Url(value, minLength);
        params.put(parameterName, base64UrlValue);
    }

    public static class Factory {
        public static PublicJsonWebKey newPublicJwk(Map<String, Object> params) throws JoseException {
            JsonWebKey jsonWebKey = JsonWebKey.Factory.newJwk(params);
            return (PublicJsonWebKey)jsonWebKey;
        }

        public static PublicJsonWebKey newPublicJwk(Key publicKey) throws JoseException {
            JsonWebKey jsonWebKey = JsonWebKey.Factory.newJwk(publicKey);
            return (PublicJsonWebKey)jsonWebKey;
        }

        public static PublicJsonWebKey newPublicJwk(String json) throws JoseException {
            Map<String, Object> parsed = JsonUtil.parseJson(json);
            return Factory.newPublicJwk(parsed);
        }
    }
}

