/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.circuits;

import com.subgraph.orchid.ExitCircuit;
import com.subgraph.orchid.Router;
import com.subgraph.orchid.Stream;
import com.subgraph.orchid.StreamConnectFailedException;
import com.subgraph.orchid.circuits.CircuitImpl;
import com.subgraph.orchid.circuits.CircuitManagerImpl;
import com.subgraph.orchid.circuits.StreamImpl;
import com.subgraph.orchid.circuits.path.CircuitPathChooser;
import com.subgraph.orchid.circuits.path.PathSelectionFailedException;
import com.subgraph.orchid.data.IPv4Address;
import com.subgraph.orchid.data.exitpolicy.ExitTarget;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeoutException;

public class ExitCircuitImpl
extends CircuitImpl
implements ExitCircuit {
    private final Router exitRouter;
    private final Set<ExitTarget> failedExitRequests;

    ExitCircuitImpl(CircuitManagerImpl circuitManager, List<Router> prechosenPath) {
        super(circuitManager, prechosenPath);
        this.exitRouter = prechosenPath.get(prechosenPath.size() - 1);
        this.failedExitRequests = new HashSet<ExitTarget>();
    }

    ExitCircuitImpl(CircuitManagerImpl circuitManager, Router exitRouter) {
        super(circuitManager);
        this.exitRouter = exitRouter;
        this.failedExitRequests = new HashSet<ExitTarget>();
    }

    @Override
    public Stream openExitStream(IPv4Address address, int port, long timeout) throws InterruptedException, TimeoutException, StreamConnectFailedException {
        return this.openExitStream(address.toString(), port, timeout);
    }

    @Override
    public Stream openExitStream(String target, int port, long timeout) throws InterruptedException, TimeoutException, StreamConnectFailedException {
        StreamImpl stream = this.createNewStream();
        try {
            stream.openExit(target, port, timeout);
            return stream;
        }
        catch (Exception e) {
            this.removeStream(stream);
            return this.processStreamOpenException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recordFailedExitTarget(ExitTarget target) {
        Set<ExitTarget> set = this.failedExitRequests;
        synchronized (set) {
            this.failedExitRequests.add(target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canHandleExitTo(ExitTarget target) {
        Set<ExitTarget> set = this.failedExitRequests;
        synchronized (set) {
            if (this.failedExitRequests.contains(target)) {
                return false;
            }
        }
        if (this.isMarkedForClose()) {
            return false;
        }
        if (target.isAddressTarget()) {
            return this.exitRouter.exitPolicyAccepts(target.getAddress(), target.getPort());
        }
        return this.exitRouter.exitPolicyAccepts(target.getPort());
    }

    @Override
    public boolean canHandleExitToPort(int port) {
        return this.exitRouter.exitPolicyAccepts(port);
    }

    @Override
    protected List<Router> choosePathForCircuit(CircuitPathChooser pathChooser) throws InterruptedException, PathSelectionFailedException {
        return pathChooser.choosePathWithExit(this.exitRouter);
    }

    @Override
    protected String getCircuitTypeLabel() {
        return "Exit";
    }
}

