/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.circuits.guards;

import com.subgraph.orchid.BridgeRouter;
import com.subgraph.orchid.DirectoryDownloader;
import com.subgraph.orchid.Router;
import com.subgraph.orchid.RouterDescriptor;
import com.subgraph.orchid.TorConfig;
import com.subgraph.orchid.circuits.guards.BridgeRouterImpl;
import com.subgraph.orchid.config.TorConfigBridgeLine;
import com.subgraph.orchid.crypto.TorRandom;
import com.subgraph.orchid.directory.downloader.DirectoryRequestFailedException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;

public class Bridges {
    private static final Logger logger = Logger.getLogger(Bridges.class.getName());
    private final TorConfig config;
    private final DirectoryDownloader directoryDownloader;
    private final Set<BridgeRouterImpl> bridgeRouters;
    private final TorRandom random;
    private final Object lock;
    private boolean bridgesInitializing;
    private boolean bridgesInitialized;
    private AtomicInteger outstandingDownloadTasks;

    Bridges(TorConfig config, DirectoryDownloader directoryDownloader) {
        this.config = config;
        this.directoryDownloader = directoryDownloader;
        this.bridgeRouters = new HashSet<BridgeRouterImpl>();
        this.random = new TorRandom();
        this.lock = new Object();
        this.outstandingDownloadTasks = new AtomicInteger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BridgeRouter chooseRandomBridge(Set<Router> excluded) throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.bridgesInitialized && !this.bridgesInitializing) {
                this.initializeBridges();
            }
            while (!this.bridgesInitialized && !this.hasCandidates(excluded)) {
                this.lock.wait();
            }
            List<BridgeRouter> candidates = this.getCandidates(excluded);
            if (candidates.isEmpty()) {
                logger.warning("Bridges enabled but no usable bridges configured");
                return null;
            }
            return candidates.get(this.random.nextInt(candidates.size()));
        }
    }

    private boolean hasCandidates(Set<Router> excluded) {
        return !this.getCandidates(excluded).isEmpty();
    }

    private List<BridgeRouter> getCandidates(Set<Router> excluded) {
        if (this.bridgeRouters.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<BridgeRouter> candidates = new ArrayList<BridgeRouter>(this.bridgeRouters.size());
        for (BridgeRouter bridgeRouter : this.bridgeRouters) {
            if (excluded.contains(bridgeRouter)) continue;
            candidates.add(bridgeRouter);
        }
        return candidates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeBridges() {
        logger.fine("Initializing bridges...");
        Object object = this.lock;
        synchronized (object) {
            if (this.bridgesInitializing || this.bridgesInitialized) {
                return;
            }
            if (this.directoryDownloader == null) {
                throw new IllegalStateException("Cannot download bridge descriptors because DirectoryDownload instance not initialized");
            }
            this.bridgesInitializing = true;
            this.startAllDownloadTasks();
        }
    }

    private List<Runnable> createDownloadTasks() {
        ArrayList<Runnable> tasks = new ArrayList<Runnable>();
        for (TorConfigBridgeLine line : this.config.getBridges()) {
            tasks.add(new DescriptorDownloader(this.createBridgeFromLine(line)));
        }
        return tasks;
    }

    private void startAllDownloadTasks() {
        List<Runnable> tasks = this.createDownloadTasks();
        this.outstandingDownloadTasks.set(tasks.size());
        for (Runnable r : tasks) {
            Thread thread = new Thread(r);
            thread.start();
        }
    }

    private BridgeRouterImpl createBridgeFromLine(TorConfigBridgeLine line) {
        BridgeRouterImpl bridge = new BridgeRouterImpl(line.getAddress(), line.getPort());
        if (line.getFingerprint() != null) {
            bridge.setIdentity(line.getFingerprint());
        }
        return bridge;
    }

    private class DescriptorDownloader
    implements Runnable {
        private final BridgeRouterImpl target;

        DescriptorDownloader(BridgeRouterImpl target) {
            this.target = target;
        }

        @Override
        public void run() {
            try {
                this.downloadDescriptor();
            }
            finally {
                this.decrementOutstandingTasks();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void downloadDescriptor() {
            block5: {
                logger.fine("Downloading descriptor for bridge: " + this.target);
                try {
                    RouterDescriptor descriptor = Bridges.this.directoryDownloader.downloadBridgeDescriptor(this.target);
                    if (descriptor == null) break block5;
                    logger.fine("Descriptor received for bridge " + this.target + ". Adding to list of usable bridges");
                    this.target.setDescriptor(descriptor);
                    Object object = Bridges.this.lock;
                    synchronized (object) {
                        Bridges.this.bridgeRouters.add(this.target);
                        Bridges.this.lock.notifyAll();
                    }
                }
                catch (DirectoryRequestFailedException e) {
                    logger.warning("Failed to download descriptor for bridge: " + e.getMessage());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void decrementOutstandingTasks() {
            if (Bridges.this.outstandingDownloadTasks.decrementAndGet() == 0) {
                logger.fine("Initial descriptor fetch complete");
                Object object = Bridges.this.lock;
                synchronized (object) {
                    Bridges.this.bridgesInitialized = true;
                    Bridges.this.lock.notifyAll();
                }
            }
        }
    }
}

