/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.directory.certificate;

import com.subgraph.orchid.KeyCertificate;
import com.subgraph.orchid.Tor;
import com.subgraph.orchid.crypto.TorPublicKey;
import com.subgraph.orchid.data.HexDigest;
import com.subgraph.orchid.data.IPv4Address;
import com.subgraph.orchid.data.Timestamp;
import java.nio.ByteBuffer;

public class KeyCertificateImpl
implements KeyCertificate {
    private IPv4Address directoryAddress;
    private int directoryPort;
    private HexDigest fingerprint;
    private TorPublicKey identityKey;
    private Timestamp keyPublished;
    private Timestamp keyExpires;
    private TorPublicKey signingKey;
    private String rawDocumentData;
    private boolean hasValidSignature = false;

    void setDirectoryPort(int port) {
        this.directoryPort = port;
    }

    void setDirectoryAddress(IPv4Address address) {
        this.directoryAddress = address;
    }

    void setAuthorityFingerprint(HexDigest fingerprint) {
        this.fingerprint = fingerprint;
    }

    void setAuthorityIdentityKey(TorPublicKey key) {
        this.identityKey = key;
    }

    void setAuthoritySigningKey(TorPublicKey key) {
        this.signingKey = key;
    }

    void setKeyPublishedTime(Timestamp time) {
        this.keyPublished = time;
    }

    void setKeyExpiryTime(Timestamp time) {
        this.keyExpires = time;
    }

    void setValidSignature() {
        this.hasValidSignature = true;
    }

    void setRawDocumentData(String rawData) {
        this.rawDocumentData = rawData;
    }

    @Override
    public boolean isValidDocument() {
        return this.hasValidSignature && this.fingerprint != null && this.identityKey != null && this.keyPublished != null && this.keyExpires != null && this.signingKey != null;
    }

    @Override
    public IPv4Address getDirectoryAddress() {
        return this.directoryAddress;
    }

    @Override
    public int getDirectoryPort() {
        return this.directoryPort;
    }

    @Override
    public HexDigest getAuthorityFingerprint() {
        return this.fingerprint;
    }

    @Override
    public TorPublicKey getAuthorityIdentityKey() {
        return this.identityKey;
    }

    @Override
    public TorPublicKey getAuthoritySigningKey() {
        return this.signingKey;
    }

    @Override
    public Timestamp getKeyPublishedTime() {
        return this.keyPublished;
    }

    @Override
    public Timestamp getKeyExpiryTime() {
        return this.keyExpires;
    }

    @Override
    public boolean isExpired() {
        if (this.keyExpires != null) {
            return this.keyExpires.hasPassed();
        }
        return false;
    }

    @Override
    public String getRawDocumentData() {
        return this.rawDocumentData;
    }

    @Override
    public ByteBuffer getRawDocumentBytes() {
        if (this.getRawDocumentData() == null) {
            return ByteBuffer.allocate(0);
        }
        return ByteBuffer.wrap(this.getRawDocumentData().getBytes(Tor.getDefaultCharset()));
    }

    public String toString() {
        return "(Certificate: address=" + this.directoryAddress + ":" + this.directoryPort + " fingerprint=" + this.fingerprint + " published=" + this.keyPublished + " expires=" + this.keyExpires + ")" + "\nident=" + this.identityKey + " sign=" + this.signingKey;
    }
}

