/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.connectors.cmis;

import java.util.Map;
import org.bonitasoft.connectors.cmis.AbstractCMISConnector;
import org.bonitasoft.connectors.cmis.cmisclient.AbstractCmisClient;
import org.bonitasoft.engine.connector.ConnectorException;

public class DeleteDocument
extends AbstractCMISConnector {
    public static final String IS_DOCUMENT_DELETED_OUTPUT = "isDocumentDeleted";
    public static final String DOCUMENT_PATH = "document_path";
    private String documentPath;

    @Override
    public void setInputParameters(Map<String, Object> parameters) {
        super.setInputParameters(parameters);
        this.documentPath = (String)parameters.get(DOCUMENT_PATH);
    }

    protected void executeBusinessLogic() throws ConnectorException {
        AbstractCmisClient cmisClient = this.getClient();
        if (cmisClient == null) {
            throw new ConnectorException("CMIS DeleteDocument connector is not connected properly.");
        }
        try {
            if (!cmisClient.checkIfObjectExists(this.documentPath).booleanValue()) {
                throw new ConnectorException("Document " + this.documentPath + "does not exist!");
            }
            cmisClient.deleteObjectByPath(this.documentPath);
            this.setOutputParameter(IS_DOCUMENT_DELETED_OUTPUT, cmisClient.checkIfObjectExists(this.documentPath) == false);
        }
        catch (Throwable throwable) {
            this.setOutputParameter(IS_DOCUMENT_DELETED_OUTPUT, cmisClient.checkIfObjectExists(this.documentPath) == false);
            throw throwable;
        }
    }
}

