/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.connectors.cmis;

import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.bonitasoft.connectors.cmis.AbstractCMISConnector;
import org.bonitasoft.connectors.cmis.cmisclient.AbstractCmisClient;
import org.bonitasoft.engine.connector.ConnectorException;

public class ListDocuments
extends AbstractCMISConnector {
    public static final String FOLDER_PATH = "folder_path";
    public static final String FOLDER_DOCUMENTS = "folder_documents";
    private String folderPath;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeBusinessLogic() throws ConnectorException {
        AbstractCmisClient cmisClient = this.getClient();
        try {
            if (cmisClient != null) {
                Folder folder = cmisClient.getFolderByPath(this.folderPath);
                ItemIterable documents = folder.getChildren();
                ArrayList<CmisObject> documentList = new ArrayList<CmisObject>();
                for (CmisObject document : documents) {
                    documentList.add(document);
                }
                this.setOutputParameter(FOLDER_DOCUMENTS, documentList);
            }
        }
        finally {
            if (!this.getOutputParameters().containsKey(FOLDER_DOCUMENTS)) {
                this.setOutputParameter(FOLDER_DOCUMENTS, null);
            }
        }
    }

    @Override
    public void setInputParameters(Map<String, Object> parameters) {
        super.setInputParameters(parameters);
        Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().toString());
        this.folderPath = (String)parameters.get(FOLDER_PATH);
        logger.log(Level.ALL, FOLDER_PATH);
    }
}

